-language([evaluate,psifcp,compound,colon]).
-export("ERK1").
baserate(1).
global([athry,ap1,erk_mp1,p_ser,ser,tyr,p_tyr,p_thr,atp,mkp1]).


ERK1:-
	<<backbone, backbone1, backbone2,  backbone3, backbone4(infinite), tyr_motif, thr_motif, atp_bs, mkp_bs .
		ERK_Nt_LOBE , ERK_CATALYTIC_CORE  .

ERK_Nt_LOBE:- backbone2 ? [] | erk_mp1 ? {cross_mp1,cross_mp2} | BOUND_ERK_Nt_LOBE(cross_mp1,cross_mp2) ;
	      backbone4 ? [] | mkp1 ! {thr_motif,tyr_motif,mkp_bs} | mkp_bs ? [] | ERK_Nt_LOBE .

	BOUND_ERK_Nt_LOBE(site1,site2):-
		site1 ! {thr_motif, tyr_motif} | site1 ! {thr_motif, tyr_motif} | site2 ! [] | ERK_Nt_LOBE;
		site2 ! [] | ERK_Nt_LOBE.

ERK_CATALYTIC_CORE :- 

	ERK_LIP(athry,tyr) , INACTIVE_ERK_KINASE , ERK_ATP_BS .

ERK_LIP(res1,res2):-
	thr_motif ! {res1}  | tyr_motif ! {res2}  | OCCUPIED_ERK_LIP(res1,res2) .

OCCUPIED_ERK_LIP(res1,res2):-
	 thr_motif ? {res1a} | << res1a=?=p_thr & res2=?=p_tyr | backbone1 ! [] | ERK_LIP(res1a,res2);
   				  res1a=?=athry & res2=?=tyr | backbone1 ! [] | ERK_LIP(res1a,res2);
   				  otherwise | OCCUPIED_ERK_LIP(res1a,res2) >> ;
 	 tyr_motif ? {res2a} | << res1=?=p_thr & res2a=?=p_tyr | backbone1 ! [] | ERK_LIP(res1,res2a);
				  res1=?=athry & res2a=?=tyr | backbone1 ! [] | ERK_LIP(res1,res2a);
				  otherwise | OCCUPIED_ERK_LIP(res1,res2a) >>. 

INACTIVE_ERK_KINASE:-
	backbone1 ? [] | ACTIVE_ERK_KINASE ;
	backbone2 ! [] | INACTIVE_ERK_KINASE .  

ACTIVE_ERK_KINASE:-
	ap1 ? {cross_motif1,cross_motif2} | cross_motif1 ? {cross_res1} | cross_motif2 ? {cross_res2} | 
			  OCCUPIED_ERK_KINASE(cross_motif1, cross_motif2, cross_res1,cross_res2) ;
	backbone1 ? [] | INACTIVE_ERK_KINASE ;
	backbone4 ! [] | ACTIVE_ERK_KINASE .
	
	
	OCCUPIED_ERK_KINASE(cross_motif1, cross_motif2,cross_res1,cross_res2):-  
    		        cross_res1=?=athry  | atp_bs ? [] | cross_motif1 ! {p_thr} | 
				OCCUPIED_ERK_KINASE(cross_motif1,cross_motif2,p_thr,cross_res2);
			cross_res2=?=ser  |  atp_bs ? [] | cross_motif2 ! {p_ser} | 
				OCCUPIED_ERK_KINASE(cross_motif1,cross_motif2,cross_res1,p_ser);	
			otherwise  |  ACTIVE_ERK_KINASE .
  

ERK_ATP_BS:-
	atp ? {adp} | atp_bs ! [] | adp ! [] | ERK_ATP_BS 
		


	>>
.









