/** This file contains the function for encryption using the PRF
 * It is important to first create the parameters of the PRF and
 * store them in the proper place and then to generate the key
 * before invoking "encrypt". 
 *
 * The file uses functions from various files including most
 * importantly the ExecutePRF file.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include "ExecutePRF.hpp"
#include "BreakBlox.hpp"
#include "Randomizer.hpp"

#define genfilePRF "data/setsystemPRF.dat"

// Fucnttion to generate the random string R used during encryption
void generateR(char R[], int n);

// The main function
main(int argc, char *argv[]) {
	 if (argc != 3) {
		  printf("\nUsage - encrypt <filename1> <filename2>\n where the file with name <filename1> contains the input text to encrypt and");
		  printf(" the file with name <filename2> contains the target file for the ciphertext\n\n");
		  exit(1);
	 }
	 
	 // Read collection from file
	 int test;
	 FILE *fp, *fp1;
	 test = (int) fopen(genfilePRF, "r");
	 if (!test) {
		  printf("\nThe file for setsystem could not be opened. Make sure you are in the right directory while executing this command.\n\n");
		  exit(1);
	 }
	 fp = fopen(genfilePRF, "r");
	 int n, d, k, l, iter, test1;
	 fscanf(fp, "%d\n%d\n", &n, &d);
	 // Read setsystem 
	 int collection[n][klimit];
	 int val, power;
	 char pred;
	 for (int k=0; k<n; k++) {
		  for (int j=0; j<d; j++) {
			   fscanf(fp, "%d\n", &val);
			   collection[k][j] = val;
		  }
	 }

	 // Read iter value
	 fscanf(fp, "%d\n", &iter);	 
	 fclose(fp);
	
	 // Read the values from the seed file
	 power = (int)pow(2.0, (double)d);
     // First n bits are the mask
	 char mask[n];
	 // Next power bits are the predicate
	 char predicate[power];
	 char c;
	 	 
	 test1 = (int) fopen(keyfile, "r");
	 if (!test1) {
		  printf("\nThe file for the key could not be opened. Make sure you are in the right directory while executing this command.\n\n");
		  exit(1);
	 }
	 fp1 = fopen(keyfile, "r");
	 for (int k=0; k<n; ++k) {
		  c = getc(fp1);
		  if ((c != '1') && (c != '0')) {
			   printf("An error occurred while reading the key from the key file. Either the specified file if faulty");
			   printf(" or the key was not generated in consonance with the setsystem. Generate the key again.\n");
			   exit(1);
		  }
		  mask[k] = c;
	 }
	 for (int k=0; k<power; ++k) {
		  c = getc(fp1);
		  if ((c != '1') && (c != '0')) {
			   printf("An error occurred while reading the key from the key file. Either the specified file if faulty");
			   printf(" or the key was not generated in consonance with the setsystem. Generate the key again.\n");
			   exit(1);
		  }
		  predicate[k] = c;
	 }
	 fclose(fp1);
 	  
	 // Generate the Random string R 
	 char R[n], block[n], PRF_R[n], outblock[n];
	 char leftoverbits[8], current_char[8]; // This records the no. of bits remaining to be converted to ASCII 
	 unsigned char bit;
	 int leftover = 0;
	 generateR(R, n);
	 
	 // Write R to o/p file
	 FILE *out;
	 test = (int) fopen(argv[2], "w");
	 if (!test) {
		  printf("\nThe file %s could not be opened. Make sure you are in the right directory while executing this command.\n\n", argv[2]);
		  exit(1);
	 }
	 out = fopen(argv[2], "w");
	 
	 for (k=0; k<n/8; ++k) {
		  for (l=0; l<8; ++l) {
			    current_char[l] = R[k*8 + l];
		  }
		  bit = bitstoChar(current_char); 
		  putc(bit, out);
	 }
	  
	 leftover = n%8;
	 for (l=0; l<leftover; ++l) 
		   leftoverbits[l] = R[(n/8)*8 + l];
	 
	 // Open plaintext file and break into blocks
	 FILE **in;
	 in = (FILE **) malloc(sizeof(FILE *));
	 test = (int) fopen(argv[1], "r");
	 if (!test) {
		  printf("\nThe file %s could not be opened. Make sure you are in the right directory while executing this command.\n\n", argv[1]);
		  exit(1);
	 }
	 *in = fopen(argv[1], "r");
	 int *remaining, pointer_start=0;
	 char eof = 0, *nextchar, tempchar; // Nextchar is the character at which the next block has to begin
	 remaining = (int *)malloc(sizeof(int));
	 nextchar = (char *)malloc(sizeof(char));
	 *remaining = 0;
	 *nextchar = 0;
	 do {
		  if (*remaining != 0) {
			   for (k=0; k < (*remaining); ++k) {
					tempchar = (*nextchar >> 1) << 1;
					block[k] = (*nextchar - tempchar) + 48;
					*nextchar = *nextchar >> 1;
			   }
			   pointer_start = k;
		  } else 
			   pointer_start = 0;
		  eof = readNextBlock(in, block, n, pointer_start, remaining, nextchar); 
		  evalPRFGiven(n, d, iter, R, mask, predicate, collection, PRF_R);
		  
		  XORMask(PRF_R, block, outblock, n);
		  
		  // Lastly, store the bits in outblock :-
		  for (l = 0; l<leftover; ++l) 
			   current_char[l] = leftoverbits[l];
		  for (l = leftover; l<8; ++l)
			   current_char[l] = outblock[l-leftover];
		  bit = bitstoChar(current_char);
		  putc(bit, out);
		  for (k=0; k < (n - (8-leftover))/8; ++k) {
			   for (l=0; l<8; ++l) 
					current_char[l] = outblock[k*8 + (8-leftover) + l];
			   bit = bitstoChar(current_char);
			   putc(bit, out);
		  }
		  
		  leftover = (n-(8-leftover))%8;
		  for (l=0; l<leftover; ++l) 
			   leftoverbits[l] = outblock[n - (leftover - l)];
	 } while(!eof);
	 
	 if (leftover != 0) {
		  for (k=0; k<leftover; ++k) 
			   current_char[k] = leftoverbits[k];
		  for (k=leftover; k<8; ++k)
			   current_char[k] = '0';
		  bit = bitstoChar(current_char);
		  putc(bit, out);
	 }
		  
	 // Put the leftover bits :-		  
	 fclose(out);
	 fclose(*in);
	 free(in);
	 // Done !
	 printf("\nThe plaintext file has been encrypted and the ciphertext has been written to the target file.\n\n");
}

void generateR(char R[], int n) {
	 Randomizer r;
	 srand(time(NULL));
	 r.init(rand(), 2);
	 for (int k=0; k < n; ++k) {
		  R[k] = (char) (r.nextNumber() + 48);
	 }
}

void putc_mine(char bit, FILE *out) {
	 if (bit == (char)EOF) {
		  putc(0, out);
		  putc((char)EOF, out);
		  putc(0, out);
	 } else 
		  putc(bit, out);
	 return;
}

