/** This code contains the main function for the generation process of the OWF.
 * It provides a user-friendly interface for receiving values for 
 * "n" and "d" for the set-system and the choice of predicate desired
 * The actual generation of the set-system and predicate occurs in
 * separate files.
 * 
 */

#include "Generate.hpp"

#define genfile "data/setsystem.dat" // To store the expanders
#define predfile "data/predicate.dat" // To store the predicate, if any
	
main() {
	 int choice;
	 
	 printf("\n");

	 // Generate the setsystem 
	 printf("Do you want to generate a new setsystem ?\n\n");
	 printf("\tEnter 1 to generate a new setsystem.\n\tEnter 0 to use the existing one\n\n");
	 printf("Your choice here - ");
	
	 while (1) {
		  scanf("%d", &choice);
		  if ((choice != 1) && (choice != 0)) 
			   printf("\nInvalid Entry. Enter again - ");
		  else 
			   break;
	 }
	
	 if (choice == 1) {
		  generateAndStoreExpander(genfile);
	 }

	 // Generate a predicate
	 printf("\n\nDo you want a new predicate (You MUST generate a new predicate if you've created a new setsystem with a new value for d) ?\n\n");
	 printf("\tEnter 1 for a new predicate.\n\tEnter 0 to use the existing one.\n\n");
	 printf("Your choice here - ");

	 while (1) {
		  scanf("%d", &choice);
		  if ((choice != 1) && (choice != 0)) 
			   printf("\nDon't fool around ! Enter a valid choice - ");
		  else 
			   break;
	 }
	
	 if (choice == 1) {
		  generateAndStorePredicate(genfile, predfile);
	 }
	 
	 printf("\nThe setsystem and predicate have been generated and stored in their respective places.\n\n");
}


