/** The following code generates the predicate that's hardwired into the 
 * one-way function. We use the system's time variable for seeding and work with
 * the Randomizer class defined elsewhere in the same directory.
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>

void givePredicate(int l, char *predicate);
void analyzeRandomness(int l, char *predicate);

// The main function to give the predicate (resp. polynomial co-efficients)
// choosing 0s and 1s at random
void givePredicate(int l, char *predicate) {
	 Randomizer r;

	 srand(time(NULL));
	 r.init(rand(), 2);
	
	 for (int k=0; k<l; k++) {
		  switch(r.nextNumber()) {
			   case 0 :
					predicate[k] = '0';
			   		break;
			   case 1 : 
					predicate[k] = '1';
					break;
		  }
	 }
}

// Function to analye the randomness in the predicate using
// simple frequency tests.
void analyzeRandomness(int l, char *predicate) {
	 // Distribution of 1's and 0's only
	 int n1, n0;
	 n1=n0=0;
	 for (int k=0; k<l; k++) {
		  if (predicate[k] == '1') {
			   n1++;
		  } else {
			   n0++;
		  }
	 }

	 printf(" \n 1's => %d, 0's => %d \n", n1, n0);

	 // Distribution of pairs...
	 int n00, n10, n01, n11;
	 n00=n01=n10=n11=0;
	 for (int k=0; k<l-1; k++) {
		  if ((predicate[k] == '0') && (predicate[k+1] == '0')) {
			   n00++;
		  } else if ((predicate[k] == '0') && (predicate[k+1] == '1')) {
			   n01++;
		  } else if ((predicate[k] == '1') && (predicate[k+1] == '0')) {
			   n10++;
		  } else {
			   n11++;
		  }
	 }
	 printf(" 00's => %d, 01's => %d, 10's => %d, 11's => %d \n", n00, n01, n10, n11);
}
		  
