/** This code defines the randomizer class which is used
 * in the generation of the predicate and the random version
 * of the expanders. We use a simple linear congruential 
 * generator with n = 1000, a = 101, b = 31.
 * 
 * The randomizer requires initialization of the system's
 * random number generator before proceeding.
 * 
 */

#include <time.h>

// Randomizer parameters :-
#define rand_mod 1000
#define rand_a 101
#define rand_b 31

// Class definition for randomizer 
class Randomizer {	 
	 public :
	 	void init(int s, int f);
	 	int nextNumber();

	 private :
	 	static const int a = rand_a;
	 	static const int b = rand_b;
	 	int factor, seed;
};

// Function to initialize it (the system's RNG is also initized)
void Randomizer::init(int s, int f) {
	 seed = s;
	 factor = f;
	 srand(seed);
}

// Function to fetch the next number in the desired range
int Randomizer:: nextNumber() {
	 seed = (seed * a + b) % rand_mod;
	 int ret = (seed + rand()) % factor;
	 return (ret);
}


