/** This file contains the functions used for breaking up the input text
 * (for encryption) and the ciphertext (for decryption) into blocks.
 * Corresponding to every character in the plaintext, 8 bits (i.e.
 * 8 characters) are put in the ciphertext. This is a bit inefficient
 * but efficiency, as already mentioned, wasn't our aim in making
 * the package.
 *
 */

// Function to read a block from the specified file stream in the encryption process
int readNextBlock(FILE **in, char block[], int n, int start, int *end, char *next) {
	 int current = start, i;
	 char curr_char, temp_char;
	 while (1) {
		  curr_char = getc(*in);
		  if ((curr_char == (char)EOF) || (curr_char == -1) || (curr_char == 0)) {
			   // Pad with 100...
			   block[current] = '1';
			   for (i=current+1; i<n; ++i) {
					block[i] = '0';
			   }
			   return 1;
		  } else {
			   // Put as much of curr_char as possible into block
			   for (i=0; i<8; ++i) {
					temp_char = (curr_char >> 1) << 1;
					block[current] = (curr_char - temp_char) + 48;
					current++;
					curr_char = curr_char >> 1;
					if (current == n)
						 break;
			   }
			   if (current == n) {
					*end = 7 - i;
					*next = curr_char;
					return 0;
			   }
		  }
	 }
}
          
// Function to dump decrypted plaintext into the tafget file. Extracts 
// characters from the current block and dumps them accordingly
void putChars(FILE **out, char block[], int lastbit, unsigned char *prev, int *rem) {
	 int current = *rem, j; // j is the index to which 2 has to be raised for diff bit positions
	 char curr_char;
	 while (1) {	  
		  *prev = 0;
		  if (lastbit - current >= 7) {
			   // Read 8 bits..put them in the out file
			   for (j=0; j<8; ++j) {
					*prev += (block[current] - 48) * (char)pow(2.0, (double)j);
					current++;
			   }
			   putc(*prev, *out);
		  } else {
			   // Read as many out of the remaining bits u can and return the leftover no. in rem and the char in prev
		       *rem = lastbit - current + 1;
			   for (j=0; j<*rem; ++j) {
					*prev += (block[current] - 48) * (char)pow(2.0, (double)j);
					current++;
			   }
			   if (*rem != 0)
					*rem = 8 - *rem;  // Number of bits extending over to the next block is in rem now !
			   else 
					*prev = 0;
			   return;
		  }
	 }
}

unsigned char bitstoChar(char bits[]) {
	 unsigned char ret = 0;
	 for (int k=0; k<8; ++k) {
		  ret *= 2;
		  if (bits[k] == '1') 
			   ret += 1;
		  else if (bits[k] != '0') {
			   printf("Error in bits-to-Character conversion");
			   exit(1);
		  }
	 }
	 return ret;
}

void chartoBits(unsigned char c, unsigned char array[]) {
	 int bitval;
	 unsigned char val = c;
	 for (int k=0; k<8; ++k) {
		  bitval = val%2;
		  array[7-k] = (bitval == 1)?'1':'0';
		  val = val/2;
	 }
}

void chartoBitsLeft(unsigned char c, char block[], int left, int n, unsigned char leftoverbits[]) {
	 int bitval;
	 unsigned char val = c;
	 for (int k=0; k<8; ++k) {
		  bitval = val%2;
		  if (k < left) 
			   leftoverbits[left - k - 1] = (bitval == 1)?'1':'0';
		  else {
			   block[n + left - k - 1] = (bitval == 1)?'1':'0';
		  }
		  val = val/2;
	 }
}

