/** This file plays the most important part in the use of the PRF 
 * and the encryption scheme based on the PRF. It contains all the
 * versions in which one can make use of the PRF. It makes use of the 
 * functions for running the OWF.
 *
 */

#include "Execute.hpp"
#include "XORFunction.hpp"

// The default files for setsystem and key :-
#define genfilePRF "data/setsystemPRF.dat"
#define keyfile "keys/key.dat"

// The main functions :-
// a) Function to use default setsystem and key (MOST IMPORTANT USAGE)
void evalPRF(char *input, char *output);

// b) Function to use specified files for the setsystem + iter (parameters)
void evalPRFGivenParams(char *input, char *gfile, char *output);

// c) Function to use specified files for the mask + predicate (seed) (ALSO IMPORTANT)
void evalPRFGivenSeed(char *input, char *sfile, char *output);

// d) Function to use specified files for parameters as well as seed
void evalPRFGivenParamsAndSeed(char *input, char *gfile, char *sfile, char *output);

// e) Function to take setsystem and key from the memory as specified
//    by arguments.
void evalPRFGiven(int n, int d, int iter, char *input, char *mask, char *predicate, 
		  int collection[][klimit], char *output);

// Version (a) - Default.
void evalPRF(char *input, char *output) {
	 evalPRFGivenParamsAndSeed(input, genfilePRF, keyfile, output);
}

// Version (b) - Given setsystem file pointer
void evalPRFGivenParams(char *input, char *gfile, char *output) {
	evalPRFGivenParamsAndSeed(input, gfile, keyfile, output); 	 
}

// Version (c) - Given seed file pointer
void evalPRFGivenSeed(char *input, char *sfile, char *output) {
	evalPRFGivenParamsAndSeed(input, genfilePRF, sfile, output); 	 
}

// Version (d) - Given setsystem and seed file pointer
void evalPRFGivenParamsAndSeed(char *input, char *gfile, char *sfile, char *output) {
	 // Read the values from setsystem file
	 FILE *fp, *fp1;
	 int test1;
	 
	 test1 = (int)fopen(gfile, "r");
	 if (!test1) {
		  printf("\nThe file for setsystem could not be opened. Make sure you are in the right directory while executing this command.\n\n");
		  exit(1);
	 }
	 fp = fopen(gfile, "r");
	 
	 int n, d, iter;
	 fscanf(fp, "%d\n%d\n", &n, &d);
	 
	 // Read setsystem 
	 int collection[n][klimit];
	 int val, power;
	 char pred;
	 for (int k=0; k<n; k++) {
		  for (int j=0; j<d; j++) {
			   fscanf(fp, "%d\n", &val);
			   collection[k][j] = val;
		  }
	 }

	 // Read iter value
	 fscanf(fp, "%d\n", &iter);
	 fclose(fp);

	 // Read the values from the seed file
	 power = (int)pow(2.0, (double)d);
     // First n bits are the mask
	 char mask[n];
	 // Next power bits are the predicate
	 char predicate[power];
	 char c;
	 
	 
	 test1 = (int) fopen(sfile, "r");
	 if (!test1) {
		  printf("\nThe file for the key could not be opened. Make sure you are in the right directory while executing this command.\n\n");
		  exit(1);
	 }
	 fp1 = fopen(sfile, "r");
	 for (int k=0; k<n; ++k) {
		  c = getc(fp1);
		  if ((c != '1') && (c != '0')) {
			   printf("An error occurred while reading the key from the key file. Either the specified file if faulty");
			   printf(" or the key was not generated in consonance with the setsystem. Generate the key again.\n");
			   exit(1);
		  }
		  mask[k] = c;
	 }
	 for (int k=0; k<power; ++k) {
		  c = getc(fp1);
		  if ((c != '1') && (c != '0')) {
			   printf("An error occurred while reading the key from the key file. Either the specified file if faulty");
			   printf(" or the key was not generated in consonance with the setsystem. Generate the key again.\n");
			   exit(1);
		  }
		  predicate[k] = c;
	 }
	 fclose(fp1);
 	 evalPRFGiven(n, d, iter, input, mask, predicate, collection, output);	 
}

void evalPRFGiven(int n, int d, int iter, char *input, char *mask, char *predicate, 
		  int collection[][klimit], char *output) {	 
	 
	 char intermediate[n]; // = input XOR mask
	 // XOR input with the mask
	 XORMask(input, mask, intermediate, n); 
     
	 // Invoke OWF !! 
	 evalGiven(n, d, intermediate, collection, predicate, output, iter, applypredicate);

	 // That's about it.
}


