/** Some general functions involving manipulation on arrays
 * as bit strings or even as arrays of other possible
 * data types. 
 *
 */

#include <iostream.h>

// Function to print an array
template<class T>
void printArray(T a[], int siz) {
	 int g=0;
	 while (g < siz) {
		  cout << a[g++] << ", ";
	 }
	 cout << "\n";
}	

// Function to compare 2 arrays of 0's and 1's
template<class T>
int comparearray(T a[], T b[], int siz) {
	 while ((a[siz-1] == b[siz-1]) && (siz > 1))
		  siz--;
	 if (a[siz-1] > b[siz-1])
		  return 1; 
	 if (a[siz-1] < b[siz-1])
		  return -1; 
	 return 0;
}

// Function only for character arrays :-
void increment(char in[], int siz) {
	 int i=0;
	 while ((i < siz) && (in[i] == '1')) 
		  in[i++] = '0';
	 if (i < siz) 
		  in[i] = '1';
}

// Function to copy one array into another
void copyarray_char(char src[], char des[], int siz) {
	 while (siz > 0) {
		  des[siz-1] = src[siz-1];
		  siz--;
	 }
}

// Function to get the final output string
void arrayToString(int n, char *input, char *output) {
	 for (int j=0; j<n; j++) {
		  output[j] = input[j];
	 }
	 output[n] = '\0';
}


