/** This file contains the function for decryption using the PRF
 * It is important to first create the parameters of the PRF and
 * store them in the proper place and then to generate the key,
 * followed by which one must first encrypt a piece of plaintext
 * to be decrypted and put it into a particular file, provided
 * as an argument to decrypt.
 *
 * The file uses functions from various files including most
 * importantly the ExecutePRF file.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include "ExecutePRF.hpp"
#include "BreakBlox.hpp"

#define genfilePRF "data/setsystemPRF.dat"

// Function to get the value of R, the random string used in encryption from
// the ciphertext.
void getR(char R[], int n);

// Main function
main(int argc, char *argv[]) {
	 if (argc != 3) {
		  printf("\nUsage - decrypt <filename1> <filename2>\n where the file with name <filename1> contains the ciphertext to decrypt and");
		  printf(" the file with name <filename2> contains the target file for the decrypted plaintext\n\n");
		  exit(1);
	 }
	 
	 // Read n from file
	 FILE *fp, *fp1;
	 int test;
	 test = (int)fopen(genfilePRF, "r");
	 if (!test) {
		  printf("\nThe file for setsystem could not be opened. Make sure you are in the right directory while executing this command.\n\n");
		  exit(1);
	 }
	 fp = fopen(genfilePRF, "r");
	 int n, d, k, l, iter, test1;
	 fscanf(fp, "%d\n%d\n", &n, &d);
	 // Read setsystem 
	 int collection[n][klimit];
	 int val, power;
	 char pred;
	 for (int k=0; k<n; k++) {
		  for (int j=0; j<d; j++) {
			   fscanf(fp, "%d\n", &val);
			   collection[k][j] = val;
		  }
	 }

	 // Read iter value
	 fscanf(fp, "%d\n", &iter);	 
	 fclose(fp);
	 
	 // Read the values from the seed file
	 power = (int)pow(2.0, (double)d);
     // First n bits are the mask
	 char mask[n];
	 // Next power bits are the predicate
	 char predicate[power];
	 char c;
	 	 
	 test1 = (int) fopen(keyfile, "r");
	 if (!test1) {
		  printf("\nThe file for the key could not be opened. Make sure you are in the right directory while executing this command.\n\n");
		  exit(1);
	 }
	 fp1 = fopen(keyfile, "r");
	 for (int k=0; k<n; ++k) {
		  c = getc(fp1);
		  if ((c != '1') && (c != '0')) {
			   printf("An error occurred while reading the key from the key file. Either the specified file if faulty");
			   printf(" or the key was not generated in consonance with the setsystem. Generate the key again.\n");
			   exit(1);
		  }
		  mask[k] = c;
	 }
	 for (int k=0; k<power; ++k) {
		  c = getc(fp1);
		  if ((c != '1') && (c != '0')) {
			   printf("An error occurred while reading the key from the key file. Either the specified file if faulty");
			   printf(" or the key was not generated in consonance with the setsystem. Generate the key again.\n");
			   exit(1);
		  }
		  predicate[k] = c;
	 }
	 fclose(fp1);
 	  
	 // Get the Random string R from the ciphertext
	 char R[n], block[n], PRF_R[n], outblock[n];
	 unsigned char leftoverbits[8];
	 unsigned char curr_char;
	 unsigned char temp[8];
	 int leftover;
	 
	 FILE *in;
	 
	 test = (int)fopen(argv[1], "r");
	 if (!test) {
		  printf("\nThe file %s could not be opened. Make sure you are in the right directory while executing this command.\n\n", argv[1]);
		  exit(1);
	 }    
	 in = fopen(argv[1], "r");
	 
	 // First read R :-
	 k = 0;
	 while (k<n/8 + 1) {
	 	  if (k < (n/8)) {
	 		   curr_char = getc(in);
	 		   chartoBits(curr_char, temp);
	 		   for (l = 0; l < 8; ++l) { 
	 				R[8*k+l] = temp[l];
			   }
	 	  } else if (n == (n/8)*8) {
	 		   leftover = 0;
	 		   break;
	 	  } else { // k = n/8 but there are more bits to extract
	 		   curr_char = getc(in);
	 		   leftover = 8 - n%8;
	 		   chartoBitsLeft(curr_char, R, leftover, n, leftoverbits);
			   break;
		  }
		  k++;
	 }    
	
     // Open plaintext file 
	 FILE **out;
	 out = (FILE **) malloc(sizeof(FILE *));
	      
	 test = (int) fopen(argv[2], "w");
	 if (!test) {
		  printf("\nThe file %s could not be opened. Make sure you are in the right directory while executing this command.\n\n", argv[2]);
		  exit(1);
	 }	  
	 *out = fopen(argv[2], "w");
	      
	 int *remaining, i, eof, lastbit, remainingBits, doneBits, nextbit_int;
	 unsigned char nextchar, nextbit, *previouschar;
	 unsigned char preserve;
	 unsigned char preserveBits[8];
	 eof = 0;
     
	 // Begin by reading first few bits
	 preserve = getc(in);
	 chartoBits(preserve, preserveBits);
	 remaining = (int *)malloc(sizeof(int));
	 previouschar = (unsigned char *)malloc(sizeof(unsigned char));
	 *remaining = 0;
	 *previouschar = 0;
     while (1) {
          for (i=0; i<leftover; ++i) { 
			   block[i] = leftoverbits[i];
          }
		  for (i=0; i<8; ++i) 
			   block[leftover+i] = preserveBits[i];
		  
		  doneBits = leftover + 8;
		  remainingBits = n - doneBits;
		  
		  i = 0;
		  while (i<remainingBits/8 + 1) {
			   if (i < (remainingBits/8)) {
					curr_char = getc(in);
					chartoBits(curr_char, temp);
					for (l = 0; l < 8; ++l) 
						 block[doneBits + 8*i + l] = temp[l];
			   } else if (remainingBits == (remainingBits/8)*8) {
					leftover = 0;
					break;
			   } else { // k = n/8 but there are more bits to extract
					curr_char = getc(in);
			   		leftover = 8 - remainingBits%8;
			   		chartoBitsLeft(curr_char, block, leftover, n, leftoverbits);
					break;
		  	   }
			   i++;
		  }
		  evalPRFGiven(n, d, iter, R, mask, predicate, collection, PRF_R);
		  XORMask(PRF_R, block, outblock, n);
		 
		  // -------------------------------------------------------------------
		  // Deal with the char remaining from the previous block, if any.......
		  // -------------------------------------------------------------------
		  if (*remaining != 0) {
			   for (i=8-*remaining; i<8; ++i) 
					*previouschar += (outblock[i + *remaining - 8] - 48) * (unsigned char)pow(2.0, (double)i); 
			   
			   putc(*previouschar, *out);
		  }
		  //--------------------------------------------------------------------
		  // Check if the end of file is reached. Record lastbit accordingly
		  // ---------------------------------------------------------------
          nextbit_int = (int)getc(in);		    
		  nextbit = (char)nextbit_int;
		  if (nextbit_int == -1) {
			   while (outblock[lastbit] == '0')
					lastbit--;
			   lastbit--;  // That's the last position at which a valid bit occurs.
			   eof = 1;
		  } else {
			   preserve = nextbit;
			   chartoBits(preserve, preserveBits);
			   lastbit = n-1;
		  }
    
		  // Now put as many complete characters in the current block as you can into
		  // the file out :-
		  // -----------------------------------------------------------------------
		  putChars(out, outblock, lastbit, previouschar, remaining);
		  if (eof == 1)
			   break;
	 }
}
	 

