/** This file contains the code for evaluating the function on 
 * the given input. Usage of default setsystem + predicate is 
 * assumed.
 *
 */

#include "Execute.hpp"

#define genfile "data/setsystem.dat"

void readFile(FILE *fp, char *input, int n);

main(int argc, char *argv[]) {
	 if (argc != 2) {
		  printf("Usage - run <filename>\n where the file with name <filename> contains the input string\n\n");
		  exit(1);
	 }
	
	 // First get the value of n stored in the generated file
	 FILE *file_gen;
	 int test1;
	 test1 = (int) fopen(genfile, "r");
	 if (!test1) {
		  printf("\nThe file for setsystem could not be opened. Make sure you are in the right directory while executing this command.\n\n");
		  exit(1);
	 }
	 file_gen = fopen(genfile, "r");
	 
	 int n;
	 fscanf(file_gen, "%d\n", &n);	 
	 fclose(file_gen);
	 
	 // Now collect the input string from the named file
	 char *filename = argv[1];
	 FILE *fp;
	 test1 = (int)fopen(filename, "r");
	 if (!test1) {
		  printf("\nThe file %s could not be opened. Make sure you are in the right directory while executing this command.\n\n", argv[1]);
		  exit(1);
	 }
	 fp = fopen(filename, "r");
	 
	 char input[n];
	 readFile(fp, input, n);	 
	 fclose(fp);
	 
	 // Now invoke the function
	 char out[n];
	 char finalout[n+1];
	 eval(input, out);
	 printf("\n");
	 arrayToString(n, input, finalout);
	 printf("Input string  - %s\n", finalout);	 
	 arrayToString(n, out, finalout);
	 printf("Output string - %s\n", finalout);	 
	 printf("\n");
}

// Function to read the file named in command line i/p
/*void readFile(FILE *fp, char *input, int n) {
	 char current;
	 for (int k=0; k<n; k++) {
		  current = getc(fp);
		  if (current == EOF) {
			   printf("Error in input file. Too few characters.\n");
			   exit(1);
		  } else if ((current != '1') && (current != '0')) {
			   printf("Error in input file. It should contain only 1's and 0's");
		  	   exit(1);
		  } else {
			   input[k] = current;
		  }
	 }
}*/


