
[s1 s2] = size(image);

HorizontalResponse = -HorizontalResponse;
VerticalResponse = -VerticalResponse;


HorizontalResponse(HorizontalResponse > 0) = 50;
HorizontalResponse(HorizontalResponse < 0) = -50;
if ShowAllFigures1
    figure; imagesc(HorizontalResponse);  axis ('image'); title('horizontal response','FontSize',14);
end

VerticalResponse(VerticalResponse > 0) = 50;
VerticalResponse(VerticalResponse < 0) = -50;
if ShowAllFigures1
    figure; imagesc(VerticalResponse);  axis ('image'); title('vertical response','FontSize',14);
end

AffinityStatisticsHorizontal = HorizontalResponse;
AffinityStatisticsVertical = VerticalResponse;


%% kernel
% below, an example for a specific kernel 
% other kernels can be applied by modifying the parameters
KernelWidth = 7; Width = 6; 
%Thresh_cut = 1.5; 
%Thresh_cut = 0.02; %for Actin Detection
Thresh_cut = 1; %for crack detecion
x = [0 : 1: 6];
sigmax = 1.5;
X = exp(-x.^2 / 2 / sigmax^2);
sigmay = 1;
y = [-3 : 1 : 3];
Y = exp(-y.^2 / 2 / sigmay^2);
A = Y' * X;
%%%%% this is the Kernel results from this operation
%  A =[  0.0111    0.0089    0.0046    0.0015    0.0003    0.0000    0.0000
%        0.1353    0.1084    0.0556    0.0183    0.0039    0.0005    0.0000
%        0.6065    0.4857    0.2494    0.0821    0.0173    0.0023    0.0002
%        1.0000    0.8007    0.4111    0.1353    0.0286    0.0039    0.0003
%        0.6065    0.4857    0.2494    0.0821    0.0173    0.0023    0.0002
%        0.1353    0.1084    0.0556    0.0183    0.0039    0.0005    0.0000
%        0.0111    0.0089    0.0046    0.0015    0.0003    0.0000    0.0000 ];



B = fliplr(A);

map1 = zeros(size(AffinityStatisticsVertical));
map2 = zeros(size(AffinityStatisticsVertical));
tmp = zeros(7,KernelWidth);

[I1 J1] = find(AffinityStatisticsVertical > 0);
[I2 J2] =  find(AffinityStatisticsVertical < 0);
% generate map1
for i=1:size(I1)
    if (I1(i) -3 <= 0) || (I1(i)+3 > s1) ||  (J1(i)+Width > s2)
        continue;
    end;
    tmp = map1(I1(i)-3:I1(i)+3,J1(i):J1(i)+Width);
    tmp = tmp+A;
    map1(I1(i)-3:I1(i)+3,J1(i):J1(i)+Width) = tmp;
end;

%generate map2
for i=1:size(I2)
    if (I2(i) -3 <= 0) || (I2(i)+3 > s1) ||  (J2(i)-Width <= 0)
        continue;
    end;
    tmp = map2(I2(i)-3:I2(i)+3,J2(i)-Width:J2(i));
    tmp = tmp+B;
    map2(I2(i)-3:I2(i)+3,J2(i)-Width:J2(i)) = tmp;
end;


VerticalMap = map1.*map2;



AA = flipud(rot90(A));
BB = rot90(A);

map1 = zeros(size(AffinityStatisticsHorizontal));
map2 = zeros(size(AffinityStatisticsHorizontal));

tmp = zeros(7,KernelWidth);
[I1 J1] = find(AffinityStatisticsHorizontal > 0);
[I2 J2] =  find(AffinityStatisticsHorizontal < 0);
% generate map1
for i=1:size(I1)
    if (I1(i) + Width > s1) || (J1(i)-3 <= 0) ||  (J1(i)+3 > s2)
        continue;
    end;
    tmp = map1(I1(i):I1(i)+Width,J1(i)-3:J1(i)+3);
    tmp = tmp + AA;
    map1(I1(i):I1(i)+Width,J1(i)-3:J1(i)+3) = tmp;
end;

% generate map2
for i=1:size(I2)
    if (I2(i) - Width <= 0) || (J2(i)-3 <= 0) ||  (J2(i)+3 > s2)
       continue;
    end;
   tmp = map2(I2(i)-Width:I2(i),J2(i)-3:J2(i)+3);
   tmp = tmp + BB;
   map2(I2(i)-Width:I2(i),J2(i)-3:J2(i)+3) = tmp;
end;

HorizontalMap = map1 .* map2;

EnhancedFiberMap = max(VerticalMap,HorizontalMap);
if ShowAllFigures1
    figure; imagesc(EnhancedFiberMap); axis('image'); colormap(gray(256));  title('vertical & horizontal','FontSize',14);
end

%% generating a binary map     
x = reshape(EnhancedFiberMap,1,s1*s2);
indexX = find(x~=0);
map_binary = EnhancedFiberMap;
index = find(map_binary < Thresh_cut);
map_binary(index) = 0;
index = find(map_binary >= Thresh_cut);
map_binary(index) = 1;
if ShowAllFigures1
    figure; imagesc(map_binary); axis('image'); colormap(gray(256));
end
%% extracting the skeleton 
BW = bwmorph(map_binary,'skel',Inf); % to get the skeleton
if ShowAllFigures1
    figure; imagesc(BW);  axis ('image'); colormap(gray(256));
end
map_intensity = zeros(size(map_binary));
index = find(BW > 0);
FiberLength = size(index);
%% connected components
[L,num] = bwlabel(map_binary,8); % Fibers to get connected components 
RGB = label2rgb(L); 
if ShowAllFigures1
    figure; imagesc(RGB); axis('image');
end
for i=1:num
    index = find(L==i);
    [k1 k2] = size(index);
    IntensitySum = 0;
    IntensitySum = IntensitySum + sum(sum(EnhancedFiberMap(index)));
    IntensityAverage = IntensitySum / k1;
    map_intensity(index) = IntensityAverage;
end;
if ShowAllFigures1
figure; imagesc(map_intensity);  axis ('image'); colormap(gray(256));
end


%% Cleaning
window = ones(15,15);
map_binary_conv = conv2(map_binary,window,'same');
clean_index = find(map_binary_conv < 40); %Fibers
map_binary_clean = map_binary;
map_binary_clean(clean_index) = 0; 
if ShowAllFigures1
    figure; imagesc(map_binary_clean); axis('image'); colormap(gray(256));
end
BW_clean = bwmorph(map_binary_clean,'skel',Inf); % to get the skeleton
if ShowAllFigures1
    figure; imagesc(BW_clean);  axis ('image'); colormap(gray(256));
end
indexC = find(BW_clean > 0);
FiberLength_clean = size(indexC); 
