function [ee,eeb,eeb_overlay,IndexedLevelMap,EdgeTable,FiberDetectionResult]=LineEdgesMain(img,Params)
%% input
% img 
% Params, obtained by SetParams.m
%
%% output
% ee - Soft Edges' Map
% eeb - Binary Edges' Map
% eeb_overlay - Binary Map overlaid on the original image
% IndexedLevelMap - colored edges according to their length
% EdgeTable - List of Edges
% FiberDetectionResult - cell array: 1. EnhancedFiberMap, 2. map_binary, 3.
% skeleton, 4. FiberLength 5. map_binary_clean 6. skeleton_clean 7. FiberLength_clean 
%% The structure of "EdgeTable" is explained below
% Each row stands for a single edge 
% with the following features in the columns:
% 1. level number
% 2. "1" for a vertical edge "3" for horizontal edge
% 3. x1 first x coordinate 
% 4. y1 first y coordinate
% 5. x2 second x coordinate
% 6. y2 second y coordinate
% 7. orientation number
% 8. absolute value of the response
% 9. signed response
% 10. detection threshold for that level
% 11. minimal contrast (signed)
% 12. maximum contrast (signed)
% 13. boundary_decision
% 14. edge length
% 15. tail length
% 16. tail response
% 17. tail thresh
% 18. Chi2 (by PB)
%% move from color to gray
if size(img,3) == 3
    img = rgb2gray(img);
end
%% convert integer to double
img = double(img);
%% intensity values are between 0-1
if (max(max(img)) >= 2 && max(max(img)) <=255)
    img = double(img) / 255;
else
    if (max(max(img)) >= 2 && max(max(img)) <= 65535)
        img = double(img) / 65535;
    end
end

%% Parameters for LineEdges Decision 
sigma = Params.sigma;
minlen = Params.minlen;
mask = Params.mask;
stdmask = Params.stdmask;
LeechMask = Params.LeechMask;
prnlen = Params.prnlen;
dc = Params.dc;
%% Fiber Detection
ApplyFiberDetection = Params.ApplyFiberDetection;
%% Parameters for non-maximal suppression
StartLevel = Params.StartLevel ;
EndLevel = Params.EndLevel;
%% Texture 
ApplyTestTexture = Params.ApplyTestTexture;
TextureThresh = Params.TextureThresh;
MidLevel = Params.MidLevel;
%% PB
ApplyTestPB = Params.ApplyTestPB;
%% Display
ShowAllFigures = Params.ShowAllFigures;
ShowAllFigures1 = Params.ShowAllFigures1;
%% An option for local test 
LocalTest = Params.LocalTest;
%%


% First, Vertical 
vert = 1;
img_original = img;
LineEdges; %includes angular and spatial non-maximal suppression 
EdgeListv = EdgeList;
EdgeListv_nosupp = EdgeList_nosupp;
VerticalResponse = Response; %used for fiber detection 
runtimev = runtime;

% Then, Horizontal 
vert = 3;
img = img_original';
LineEdges; %includes angular and spatial non-maximal suppression 
HorizontalResponse = Response'; % used for fiber detection 
if isempty(EdgeList)
    EdgeListh = [];
else
    EdgeListh = [EdgeList(:,1) EdgeList(:,2)  EdgeList(:,4) EdgeList(:,3) EdgeList(:,6)...
                EdgeList(:,5) EdgeList(:,7:end)]; % now [ x1 y1 x2 y2]
end
EdgeList = [EdgeListv; EdgeListh];
if isempty(EdgeList_nosupp)
    EdgeListh_nosupp = [];
else
    EdgeListh_nosupp = [EdgeList_nosupp(:,1) EdgeList_nosupp(:,2)  EdgeList_nosupp(:,4) EdgeList_nosupp(:,3) EdgeList_nosupp(:,6)...
                EdgeList_nosupp(:,5) EdgeList_nosupp(:,7:end)]; % now [ x1 y1 x2 y2]
end
EdgeList_nosupp = [EdgeListv_nosupp; EdgeListh_nosupp];
runtimeh = runtime + max(runtimev);
%return;
imgout = zeros(size(img_original));
imgout_nosupp = zeros(size(img_original));
% Draw accepted responses
if not(isempty(EdgeList))
    h = vision.ShapeInserter;
    release(h);%allows changing ShapeInserter object properties.
    set(h,'Shape','Lines');
    set(h,'BorderColor','White');%draws white color on black image.
    pts = EdgeList(:,3:6);
    imgout = step(h,imgout,pts);%performs the drawing.
end
if not(isempty(EdgeList_nosupp))
    h = vision.ShapeInserter;
    release(h);%allows changing ShapeInserter object properties.
    set(h,'Shape','Lines');
    set(h,'BorderColor','White');%draws white color on black image.
    pts = EdgeList_nosupp(:,3:6);
    imgout_nosupp = step(h,imgout_nosupp,pts);%performs the drawing.
end

if ShowAllFigures1
    figure;imagesc(img_original);axis image; colormap gray; title (' original image ','FontSize',14); drawnow;
end
if ShowAllFigures
    figure;imagesc(imgout_nosupp);axis image; colormap gray; title (' without suppression ','FontSize',14); drawnow;
    figure;imagesc(imgout);axis image; colormap gray; title (' after intra-level suppression: angular and spatial ','FontSize',14); drawnow;
end
    
tic;
%% Fiber Detection before NMS
image = img_original;
% according to the flag "ApplyFiberDetection", perform Fiber Detection
FiberDetectionResult = cell(1,7); % will be empty if (ApplyFiberDetection == 0);
if ~isempty(EdgeList)
    if (ApplyFiberDetection)
        DetectFibersNew;
        FiberDetectionResult{1} = EnhancedFiberMap;
     % Binary results before cleaning 
        FiberDetectionResult{2} = map_binary;
        FiberDetectionResult{3} = BW; % skeleton
        FiberDetectionResult{4} = FiberLength;  
     % Binary results after cleaning    
        FiberDetectionResult{5} = map_binary_clean;
        FiberDetectionResult{6} = BW_clean;
        FiberDetectionResult{7} = FiberLength_clean;
    end
end
%% perform inter-level non-maximal suppression 
image = img_original;
if ~isempty(EdgeList)
    NMS; %inter-level non-maximal suppression
         % The output from NMS is "EdgeListFinal"
         % in case Texture Tests are not used 
    ee = ee*255 / max(max(ee));
else
    ee = zeros(size(image));
    eeb = zeros(size(image));
    eeb_overlay = image;
    IndexedLevelMap = zeros(size(image));
    EdgeListFinal = [];
    EdgeTable = [];
end

%% dealing with natural images
image = img_original;
if ~isempty(EdgeListFinal)
    %% first option - texture filtering
    if (ApplyTestTexture)
        TestTexture33;
        ee(ee > TextureThresh) = max(max(ee));
        ee = ee*255 / max(max(ee));
    end
    %% second option - calculate soft edges by PB
    if (ApplyTestPB)
        image = 255*img_original;
        DrawEdgesByPB; % A column is added to EdgeListFinal, containing "Chi2" information (by PB).
        EdgeTable = EdgeListFinal;
        ee = ResponseMap1;
        ee = ee*255 / max(max(ee));
    end
else
    ee = zeros(size(image));
    eeb = zeros(size(image));
    IndexedLevelMap = zeros(size(image));
    eeb_overlay = image;
    EdgeTable = [];
end
%% run time
runtimeNMS = toc;

fprintf(1,'Image size %4d x %4d, run time: %6.2f secs (bottom-up %6.2f secs)\n',...
    size(image,2),size(image,1),runtimeNMS + max(runtimeh),max(runtimeh));
end