EdgeListFinal = [EdgeListFinal zeros(size(EdgeListFinal,1),1)];
% Based on DrawEdgesByHistogram1 
radius = 7; 
%prepare template of disc with radius r
disc = zeros(2*radius+1,2*radius+1);
distances = zeros(2*radius+1,2*radius+1);
for i=1:2*radius+1
    for j=1:2*radius+1
        distances(i,j) = sqrt((i-radius-1)*(i-radius-1) + (j-radius-1)*(j-radius-1));
        if (distances(i,j) <= radius) 
            disc(i,j) =1;
        end
    end
end
% smoothing parameters
sigma_smoothing = 0.2;
d = (-2*sigma_smoothing:4*sigma_smoothing/22:2*sigma_smoothing);
s = exp (-d.*d  / 2 / sigma_smoothing^2);
s = s / sum(s);
%
ResponseMap1 = zeros(size(image)); 
size(image)
[len1 len2] = size(image);
% use EdgeListFinal, the output of the NMS
X1 = EdgeListFinal(:,3); 
Y1 = EdgeListFinal(:,4);  
X2 = EdgeListFinal(:,5);  
Y2 = EdgeListFinal(:,6);  



for Level=StartLevel:EndLevel

%IntegralLength = 2^(Level-1) + 1;
Index = find(EdgeListFinal(:,1) == Level); 

%VerticalIndex = find((EdgeList(:,1) == Level) & ((EdgeList(:,2) == 1) | (EdgeList(:,2) == 2)));
%HorizontalIndex = find((EdgeList(:,1) == Level) & ((EdgeList(:,2) == 3) | (EdgeList(:,2) == 4)));



%plot the edges
% for i=1:length(Index)
%     I = Index(i);
%     x = [X1(I) X2(I)]';
%     y = [Y1(I) Y2(I)]';
%     hold on; plot(x+1,y+1,'g');
% %    pause;
% end;



for i=1:length(Index)
    I = Index(i);
    x = [X1(I) X2(I)];
    y = [Y1(I) Y2(I)];
    [cx cy c] = improfile(image,x,y,'nearest');
    rcx = round(cx); rcy = round(cy);
    % calculate center of the edge (after discretization of the layout)
    row= rcy(round(length(rcy)/2)); col = rcx(round(length(rcx)/2));
%    figure(20); hold on; plot(col(I)+1,row(I)+1,'m.');
% calculate histograms on both sides of this edge 
% Hf
    Hf = zeros(size(image));
%    Hf(max(1,1+row(I)-radius):min(len1,1+row(I)+radius),max(1,1+col(I)-radius):min(len2,1+col(I)+radius)) = disc; %bounding box
    Hf(row,col) = 0; %zero center
% Hg
    Hg = zeros(size(image));
%    Hg(max(1,1+row(I)-radius):min(len1,1+row(I)+radius),max(1,1+col(I)-radius):min(len2,1+col(I)+radius)) = disc; %bounding box
    Hg(row,col) = 0; %zero center
% ignore image margins
    if ((row-radius < 1) || (row+radius > len1) ||  (col-radius < 1) || (col+radius > len2))
%    figure(20); hold on; plot(col(I)+1,row(I)+1,'k.');
    continue;
    else
      Hf(row-radius:row+radius,col-radius:col+radius) = disc; %bounding box 
      Hg(row-radius:row+radius,col-radius:col+radius) = disc; %bounding box
    end
        
        
%%%

    for k=1:length(rcx)
       if ((rcx(k) > 0) && (rcx(k) <= len2) && (rcy(k) > 0) && (rcy(k) <= len1))
% Vertical Edge           
            if (EdgeListFinal(I,2) == 1)
                Hf(rcy(k),1:rcx(k)) = 0;
                Hg(rcy(k),rcx(k):end) = 0;
            end
% Horizonatl Edge           
            if (EdgeListFinal(I,2) == 3)
                Hf(1:rcy(k),rcx(k)) = 0;
                Hg(rcy(k):end,rcx(k)) = 0;
            end        
       end
    end  
% Vertical Edge           
            if (EdgeListFinal(I,2) == 1)
                Hf(row,1:col) = 0;
                Hg(row,col:end) = 0;
            end
% Horizonatl Edge           
            if (EdgeListFinal(I,2) == 3) 
                Hf(1:row,col) = 0;
                Hg(row:end,col) = 0;
            end      
    indexf = find(Hf ~= 0);
    indexg = find(Hg ~= 0);
    f = double(image) .* Hf;
    g = double(image) .* Hg;
%    figure(5); hold off; hist(f(indexf),[0:255]); 
%    figure(10); hold off; hist(g(indexg),[0:255]);
    F = hist(f(indexf),(0:255));
    G = hist(g(indexg),(0:255));
    F = conv(F,s); 
    G = conv(G,s); 
    indexCommon = find((G+F)~=0);
    Chi2 = 0.5*sum((G(indexCommon)-F(indexCommon)).^2 ./ (G(indexCommon)+F(indexCommon)));
%    figure(30); hold off; plot(F); 
%    figure(40); hold off; plot(G); 
%    pause;
%    figure(20); hold on; plot(col(I)+1,row(I)+1,'k.');
    for k=1:length(rcx)
        if ((rcx(k) > 0) && (rcx(k) <= len2) && (rcy(k) > 0) && (rcy(k) <= len1))
            ResponseMap1(rcy(k),rcx(k)) = max(ResponseMap1(rcy(k),rcx(k)),Chi2);
        end
    end
    ResponseMap1(row,col) = max(ResponseMap1(row,col),Chi2);
    EdgeListFinal(I,end) = Chi2;
end    
end
if ShowAllFigures1
    figure; imagesc(ResponseMap1); axis('image'); colormap(gray); title(' PB map ','FontSize',14);
end









