tic;
[height,width] = size(img);
runtime = zeros(1,1+floor(log2(width-1)));

EdgeList = [];
EdgeList_nosupp = [];

sumabsmask = sum(abs(mask));
sumstdmask = sum(stdmask);
%halfmask = sum(mask > 0);
halfmask = floor(length(mask)/2);
logN = log(width * height);
sigma_n = sigma*(sumabsmask * minlen)^(-0.5) - dc; % std of the noise model 
len = 1;

% Image squared for local std calculation
img2 = img .^ 2;

% Initialization, vertical orientations
Hnew = zeros(height-1,width,3);
Hnew(:,2:end,1)   = 0.5 * (img(1:end-1,2:end) + img(2:end,1:end-1));
Hnew(:,:,2)       = 0.5 * (img(1:end-1,:) + img(2:end,:));
Hnew(:,1:end-1,3) = 0.5 * (img(1:end-1,1:end-1) + img(2:end,2:end));

H2new = zeros(height-1,width,3);
H2new(:,2:end,1)   = 0.5 * (img2(1:end-1,2:end) + img2(2:end,1:end-1));
H2new(:,:,2)       = 0.5 * (img2(1:end-1,:) + img2(2:end,:));
H2new(:,1:end-1,3) = 0.5 * (img2(1:end-1,1:end-1) + img2(2:end,2:end));

Hprev = Hnew;
H2prev = H2new;

if minlen == 1
    % Compute responses and local stds
    Rnew = convn(Hnew,mask,'same') / sumabsmask;
    Snew = convn(sqrt(H2new - (Hnew .^ 2)),stdmask,'same') / sumstdmask;

    
    % Clear responses at margins of image
    Rnew(:,1:halfmask,len+1) = 0;
    Rnew(:,end-halfmask+1:end,len+1) = 0;
    for t = 1:len
        pos = len+1+t;
        neg = len+1-t;
        Rnew(:,1:halfmask,pos) = 0;
        Rnew(:,max(1,width-halfmask-t+1):end,pos) = 0;
        Rnew(:,1:min(width,halfmask+t),neg) = 0;
        Rnew(:,max(1,width-halfmask+1):end,neg) = 0;
    end
    
    % Accumulating minimal response
    Mprev = Rnew;  % Initialize minimum
    Eprev = Rnew;  % Initialize maximum
end

runtime(1)=toc;

% Vertical orientations
while size(Hprev,1) > 1

    len = 2 * len;
    T = 2*len + 1;
    thresh = sqrt(2 * logN / (sumabsmask * len));
    

    Hnew = zeros(size(Hprev,1)-1,width,T);
    H2new = zeros(size(H2prev,1)-1,width,T);
    % Sum pairs along the vertical orientation
    Hnew(:,:,len+1) = 0.5*(Hprev(1:end-1,:,len/2+1) + Hprev(2:end,:,len/2+1));
    H2new(:,:,len+1) = 0.5*(H2prev(1:end-1,:,len/2+1) + H2prev(2:end,:,len/2+1));
    for t = 1:len/2
        % Sum pairs along same orientation
        t2 = 2*t;
        tpos2 = len + 1 + t2;
        tpos = len/2 + 1 + t;
        tneg2 = len + 1 - t2;
        tneg = len/2 + 1 - t;
        Hnew(:,t2+1:end,tneg2) = 0.5*(Hprev(1:end-1,t2+1:end,tneg) + Hprev(2:end,t+1:end-t,tneg));
        Hnew(:,1:end-t2,tpos2) = 0.5*(Hprev(1:end-1,1:end-t2,tpos) + Hprev(2:end,t+1:end-t,tpos));
        H2new(:,t2+1:end,tneg2) = 0.5*(H2prev(1:end-1,t2+1:end,tneg) + H2prev(2:end,t+1:end-t,tneg));
        H2new(:,1:end-t2,tpos2) = 0.5*(H2prev(1:end-1,1:end-t2,tpos) + H2prev(2:end,t+1:end-t,tpos));

        % New orientations: parallelogram rule
        t2 = 2*t-1;
        tpos2 = len + 1 + t2;
        tpos = len/2 + 1 + t;
        tneg2 = len + 1 - t2;
        tneg = len/2 + 1 - t;
        Hnew(:,t2+1:end,tneg2) = 0.25 * (Hprev(1:end-1,t2+1:end,tneg) + Hprev(1:end-1,t2+1:end,tneg+1) +...  
                                        Hprev(2:end,t:end-t,tneg+1) + Hprev(2:end,t+1:end-t+1,tneg));
        Hnew(:,1:end-t2,tpos2) = 0.25 * (Hprev(1:end-1,1:end-t2,tpos-1) + Hprev(1:end-1,1:end-t2,tpos) +...  
                                        Hprev(2:end,t:end-t,tpos) + Hprev(2:end,t+1:end-t+1,tpos-1));
        H2new(:,t2+1:end,tneg2) = 0.25 * (H2prev(1:end-1,t2+1:end,tneg) + H2prev(1:end-1,t2+1:end,tneg+1) +...  
                                        H2prev(2:end,t:end-t,tneg+1) + H2prev(2:end,t+1:end-t+1,tneg));
        H2new(:,1:end-t2,tpos2) = 0.25 * (H2prev(1:end-1,1:end-t2,tpos-1) + H2prev(1:end-1,1:end-t2,tpos) +...  
                                        H2prev(2:end,t:end-t,tpos) + H2prev(2:end,t+1:end-t+1,tpos-1));
    end
    
    % Compute responses and local stds
     Rnew = convn(Hnew,mask,'same') / sumabsmask;
     Snew = convn(sqrt(H2new - (Hnew .^ 2)),stdmask,'same') / sumstdmask;

     % Clear responses at margins of image
     Rnew(:,1:halfmask,len+1) = 0;
     Rnew(:,end-halfmask+1:end,len+1) = 0;
     Snew(:,1:halfmask,len+1) = 0;
     Snew(:,end-halfmask+1:end,len+1) = 0;
     for t = 1:len
         pos = len+1+t;
         neg = len+1-t;
         Rnew(:,1:halfmask,pos) = 0;
         Rnew(:,max(1,width-halfmask-t+1):end,pos) = 0;
         Rnew(:,1:min(width,halfmask+t),neg) = 0;
         Rnew(:,max(1,width-halfmask+1):end,neg) = 0;
         Snew(:,1:halfmask,pos) = 0;
         Snew(:,max(1,width-halfmask-t+1):end,pos) = 0;
         Snew(:,1:min(width,halfmask+t),neg) = 0;
         Snew(:,max(1,width-halfmask+1):end,neg) = 0;
     end
     
    % Accumulating minimal response
    if len <= minlen
        Mnew = Rnew;  % Initialize minimum
        Enew = Rnew;  % Initialize maximum
    else
        Mnew = zeros(size(Rnew));
        Enew = zeros(size(Rnew));
        % Min pairs along the vertical orientation
        Mnew(:,:,len+1) = min(Mprev(1:end-1,:,len/2+1),Mprev(2:end,:,len/2+1));
        % Max pairs along the vertical orientation
        Enew(:,:,len+1) = max(Eprev(1:end-1,:,len/2+1),Eprev(2:end,:,len/2+1));
        for t = 1:len/2
            % Minimum and Maximum of pairs along same orientation
            t2 = 2*t;
            tpos2 = len + 1 + t2;
            tpos = len/2 + 1 + t;
            tneg2 = len + 1 - t2;
            tneg = len/2 + 1 - t;
            Mnew(:,t2+1:end,tneg2) = min(Mprev(1:end-1,t2+1:end,tneg),Mprev(2:end,t+1:end-t,tneg));
            Mnew(:,1:end-t2,tpos2) = min(Mprev(1:end-1,1:end-t2,tpos),Mprev(2:end,t+1:end-t,tpos));
            %
            Enew(:,t2+1:end,tneg2) = max(Eprev(1:end-1,t2+1:end,tneg),Eprev(2:end,t+1:end-t,tneg));
            Enew(:,1:end-t2,tpos2) = max(Eprev(1:end-1,1:end-t2,tpos),Eprev(2:end,t+1:end-t,tpos));
            % New orientations: Minimum and Maximum of parallelogram
            t2 = 2*t-1;
            tpos2 = len + 1 + t2;
            tpos = len/2 + 1 + t;
            tneg2 = len + 1 - t2;
            tneg = len/2 + 1 - t;

            Mnew(:,t2+1:end,tneg2) = min(min(Mprev(1:end-1,t2+1:end,tneg),Mprev(2:end,t:end-t,tneg+1)),...
                min(Mprev(1:end-1,t2+1:end,tneg+1),Mprev(2:end,t+1:end-t+1,tneg)));
            Mnew(:,1:end-t2,tpos2) = min(min(Mprev(1:end-1,1:end-t2,tpos-1),Mprev(2:end,t:end-t,tpos)),...
                min(Mprev(1:end-1,1:end-t2,tpos),Mprev(2:end,t+1:end-t+1,tpos-1)));
            %
            Enew(:,t2+1:end,tneg2) = max(max(Eprev(1:end-1,t2+1:end,tneg),Eprev(2:end,t:end-t,tneg+1)),...
                max(Eprev(1:end-1,t2+1:end,tneg+1),Eprev(2:end,t+1:end-t+1,tneg)));
            Enew(:,1:end-t2,tpos2) = max(max(Eprev(1:end-1,1:end-t2,tpos-1),Eprev(2:end,t:end-t,tpos)),...
                max(Eprev(1:end-1,1:end-t2,tpos),Eprev(2:end,t+1:end-t+1,tpos-1)));
        end
    end
    % keep the values of the local std's before the next statement
    sigmaSnew = Snew;   
    % determine boundary decision 
    Snew = Snew * (sumabsmask * minlen)^(-0.5);
    Snew(Snew < sigma_n) = sigma_n;
    % sigma_local > sigma_n
    A = Snew.^2 - sigma_n^2;
    B = 2*sigma_n^2*abs(Rnew); 
    C = 2*Snew.^2*sigma_n^2.*(log(sigma_n)-log(Snew))-sigma_n^2*Rnew.^2;
    boundary_decision = (-B+(B.^2-4.*A.*C).^0.5);
    boundary_decision(Snew == sigma_n) = abs(Rnew(Snew == sigma_n)) / 2; %sigma_local = sigma_n
    boundary_decision(Snew > sigma_n) = boundary_decision(Snew > sigma_n)./2./A(Snew > sigma_n); %sigma_local > sigma_n
    
    % Accepted responses
    if LocalTest
        Tnew = (abs(Rnew) > sigmaSnew * thresh-dc) .* abs(Rnew);
    else
        Tnew = (abs(Rnew) > sigma * thresh-dc) .* abs(Rnew);
    end
    Tnew = Tnew .* ((Mnew.*sign(Rnew) > boundary_decision) & (Enew.*sign(Rnew) > boundary_decision));
    
    % Angular NMS: suppress responses through same centers
    % Find the maximal response for each center and record its direction
    % Start with vertical direction (if response > threshold)
    AngMax = Tnew(:,:,len+1);
    tMax = (len+1) * (Tnew(:,:,len+1) > 0);

    AngMaxHalf = zeros(size(AngMax));
    tMaxHalf = zeros(size(AngMaxHalf));
    tmp = zeros(size(tMax));
    
    for t2=2:2:len
        t = t2 / 2;
        tmp(:,:) = 0;
        tmp(:,t+1:end) = AngMax(:,t+1:end) < Tnew(:,1:end-t,len+1+t2);
        tMax = (tMax .* ~tmp) + ((len+1+t2) * tmp);
        AngMax(:,t+1:end) = max(AngMax(:,t+1:end),Tnew(:,1:end-t,len+1+t2));
        tmp(:,:) = 0;
        tmp(:,1:end-t) = AngMax(:,1:end-t) < Tnew(:,t+1:end,len+1-t2);
        tMax = (tMax .* ~tmp) + ((len+1-t2) * tmp);
        AngMax(:,1:end-t) = max(AngMax(:,1:end-t),Tnew(:,t+1:end,len+1-t2));
        % max of half-pixel centers
        t2half = t2 - 1;
        tmp(:,:) = 0;
        tmp(:,t+1:end) = AngMaxHalf(:,t+1:end) < Tnew(:,1:end-t,len+1+t2half);
        tMaxHalf = (tMaxHalf .* ~tmp) + ((len+1+t2half) * tmp);
        AngMaxHalf(:,t+1:end) = max(AngMaxHalf(:,t+1:end),Tnew(:,1:end-t,len+1+t2half));
        tmp(:,:) = 0;
        tmp(:,1:end-t) = AngMaxHalf(:,1:end-t) < Tnew(:,t+1:end,len+1-t2half);
        tMaxHalf = (tMaxHalf .* ~tmp) + ((len+1-t2half) * tmp);
        AngMaxHalf(:,1:end-t) = max(AngMaxHalf(:,1:end-t),Tnew(:,t+1:end,len+1-t2half));    
    end
    
    % Spatial suppression
    % Each center looks at two neighboring pixel and two half pixel centers
    ind = ones(size(AngMax));
    ind(:,1:end-1) = AngMax(:,1:end-1) >= AngMax(:,2:end);
    ind(:,2:end) = ind(:,2:end) & ~ind(:,1:end-1);
    ind = ind & (AngMax >= AngMaxHalf);
    ind(:,2:end) = ind(:,2:end) & (AngMax(:,2:end) >= AngMaxHalf(:,1:end-1));
    
    indhalf = ones(size(AngMaxHalf));
    indhalf(:,1:end-1) = AngMaxHalf(:,1:end-1) >= AngMaxHalf(:,2:end);
    indhalf(:,2:end) = indhalf(:,2:end) & ~indhalf(:,1:end-1);
    indhalf = indhalf & (AngMax < AngMaxHalf);
    indhalf(:,1:end-1) = indhalf(:,1:end-1) & (AngMax(:,2:end) < AngMaxHalf(:,1:end-1));
    
    Tsupp = zeros(size(Tnew));
    Tsupp(:,:,len+1) = AngMax .* (tMax == len+1) .* ind;
    for t2=2:2:len
        t = t2 / 2;
        Tsupp(:,1:end-t,len+1+t2) = AngMax(:,t+1:end) .* (tMax(:,t+1:end) == len+1+t2) .* ind(:,t+1:end);
        Tsupp(:,t+1:end,len+1-t2) = AngMax(:,1:end-t) .* (tMax(:,1:end-t) == len+1-t2) .* ind(:,1:end-t);
        t2half = t2 - 1;
        Tsupp(:,1:end-t,len+1+t2half) = AngMaxHalf(:,t+1:end) .* (tMaxHalf(:,t+1:end) == len+1+t2half) .* indhalf(:,t+1:end);
        Tsupp(:,t+1:end,len+1-t2half) = AngMaxHalf(:,1:end-t) .* (tMaxHalf(:,1:end-t) == len+1-t2half) .* indhalf(:,1:end-t);
    end
    
    % Prepare for next level
    Hprev = Hnew(1:2:end,:,:);
    H2prev = H2new(1:2:end,:,:);
    Mprev = Mnew(1:2:end,:,:);
    Eprev = Enew(1:2:end,:,:);
    
    % Store accepted responses for Meirav's NMS
    if len >= prnlen
        ind = find(Tsupp);
        if not(isempty(ind))
            [y,x1,t] = ind2sub(size(Tsupp),ind);
            y1 = 1 + (y-1) * len/2;
            x2 = x1 + t - (len + 1);
            y2 = y1 + len;
            % for Meirav's NMS
            EdgeList = [EdgeList;...
                log2(len)+1 * ones(size(x1)), vert * ones(size(x1)),...
                x1, y1, x2, y2, (2*len+1)*mod(y,2)+t,...
                Tsupp(ind), Rnew(ind), sigma*thresh*ones(size(x1)),  Mnew(ind), Enew(ind), boundary_decision(ind)];
        end
        indTnew = find(Tnew);
        if not(isempty(indTnew))
            [y,x1,t] = ind2sub(size(Tnew),indTnew);
            y1 = 1 + (y-1) * len/2;
            x2 = x1 + t - (len + 1);
%            y2 = y1 + len - 1;
            y2 = y1 + len;
            % for debugging
            EdgeList_nosupp = [EdgeList_nosupp;...
                log2(len)+1 * ones(size(x1)), vert * ones(size(x1)),...
                x1, y1, x2, y2, (2*len+1)*mod(y,2)+t,...
                Tnew(indTnew), Rnew(indTnew), sigma*thresh*ones(size(x1)), Mnew(indTnew), Enew(indTnew), boundary_decision(indTnew)];
        end
    end
    runtime(log2(len)+1) = toc;
end
%
%% Draw two images, one for the SIGNED horizontal responses and the other for the SIGNED vertical responses 
% prepare two maps which will be used for fiber detection 
% LineEdges is called twice.
% The first "Response" is the "VerticalResponse"
% The second "Response" is the "HorizontalResponse"
Response = zeros(size(img));
if ~isempty(EdgeList)
        IndexEdges = find(EdgeList(:,2) == vert); 
%
        x1 = EdgeList(IndexEdges,3);
        y1 = EdgeList(IndexEdges,4);
        x2 = EdgeList(IndexEdges,5);
        y2 = EdgeList(IndexEdges,6);
%        
        color = (EdgeList(IndexEdges,9));
        h = vision.ShapeInserter;
        release(h);%allows changing ShapeInserter object properties.
        set(h,'Shape','Lines');
        set(h,'BorderColor','Custom');%setting border color to custom.
        set(h,'CustomBorderColor',color);%sets line color,color is an R element vector.
        pts=[x1, y1, x2, y2];
        Response = step(h,Response,pts);%performs the drawing.
end
%

