%% length is defined as the number of sub-intervals, the length is given in power of 2.
% length = 2^(level number - 1)
%% level number is defined as log_2(length)+1  
% length=1 *---*            level = 1   
% length=2 *---*---*        level = 2
% length=4 *---*---*---*    level = 3
% etc...
%% Parameters for LineEdges Decision 
Params.sigma = 0.04; % determines the noise level (0-1)
Params.dc = 0.0000;  % typically 0
Params.minlen = 4;   % The length of the basic element for the consistent contrast test (powers of 2, typically 2 or 4)
Params.mask = [-1 -1 -1 0 1 1 1]; % the matched filter
%Params.mask = [-1 0 1];
%Params.mask = [ -1 -1 0 1 1];
%Params.mask = [-1 -1 0 0 0 1 1]; 
Params.stdmask = [1 1 0 0 0 1 1]; % calculating the std for the consistent contrast test
%Params.stdmask = [0 1 0 0 0 1 0];
%Params.stdmask = [1 0 1];
Params.LeechMask = Params.mask;
Params.prnlen = 4;    % powers of 2
                      % Responses are stored in a table for the NMS process,
                      % starting at this length, should be greater or equal "Params.minlen" 
%% Parameters for the non-maximal-suppression (NMS)
Params.StartLevel = log2(Params.prnlen)+1; % Start scanning the edges' table from this level
                                           % Lower levels will not be displayed
Params.EndLevel = 10;   % Stop scanning the edges' table at this level.
%% Parameters for generating soft maps for natural images 
% Choose either TestTexture or TestBP (Not Both) or none of them
Params.ApplyTestTexture = 0; % assign 1 for TestTexture; 
Params.TextureThresh = 0.8;
Params.MidLevel = 10; %  StartLevel<= MidLevel <= EndLevel
                      %  in case texture is applied the entropy influences only levels lower than MidLevel
%
Params.ApplyTestPB = 0; %assign 1 for TestBP
%
if (Params.ApplyTestTexture && ApplyTestPB)
    Params.ApplyTestTexture = 0;
    Params.ApplyTestPB = 1;
end 
%% Display - in case of batch runs both flags should be turned off
Params.ShowAllFigures1 = 1; % recommended
Params.ShowAllFigures = 0;  % if in addition it is set to 1, then more figures will be displayed
%% An option for local test 
Params.LocalTest = 0; % not recommended
%% Parameters for Fiber Detection; it is performed before the NMS 
Params.ApplyFiberDetection = 0;