% input:
% 1. image
% 2. EdgeListFinal

ee = zeros(size(image));
%eev = zeros(size(image)); %edge entropy for vertical responses
%eeh = zeros(size(image));
nbins = 16;  % orientations, +1 for no gradient
pxsize = 1;
pysize =5;
mag_thresh = 0.05; % gradient magnitude below this thresh is not considered

binsize = 2 * pi / nbins;
psize2 = pxsize * pysize;

mx = [-1 0 1; -2 0 2; -1 0 1];
my = mx';
nrm = sum(abs(mx(:)));
mx = mx/nrm;
my = my/nrm;

ix = conv2(image,mx,'same');
iy = conv2(image,my,'same');

mag = sqrt(ix.^2 + iy.^2);
theta = atan2(iy,ix);
dtheta = min(nbins,1+floor(max(0,(theta + pi)) / binsize));
dtheta(mag <= mag_thresh) = nbins+1;

% The highest levels contribute response only
for Level=EndLevel:-1:(MidLevel+1)
    num_of_directions = 2*(2^Level + 1); 
%    
    for t=1:num_of_directions
        IndexVertical = find((EdgeListFinal(:,1) == Level) & (EdgeListFinal(:,2) == 1) & (EdgeListFinal(:,7) == t));
        num_of_pairs = size(IndexVertical,1);
        if (num_of_pairs == 0)
            continue;
        end

        x1 = EdgeListFinal(IndexVertical,3);
        y1 = EdgeListFinal(IndexVertical,4);
        x2 = EdgeListFinal(IndexVertical,5);
        y2 = EdgeListFinal(IndexVertical,6);
%
        color = (1:1:num_of_pairs);
        h = vision.ShapeInserter;
        release(h);%allows changing ShapeInserter object properties.
        set(h,'Shape','Lines');
        set(h,'BorderColor','Custom');%setting border color to custom.
        set(h,'CustomBorderColor',color);%sets line color,color is an R element vector.
        pts=[x1, y1, x2, y2];
        PixelMap = zeros(size(image));
        PixelMap = step(h,PixelMap,pts);%performs the drawing.
% mask can be changed by introducing convolution  
        for I=1:num_of_pairs
            PixelMap_I = (PixelMap == I);
            ee = max(PixelMap_I*EdgeListFinal(IndexVertical(I),8)/ThreshValue(Level),ee);
        end
    end
    
    for t=1:num_of_directions
        IndexHorizontal = find((EdgeListFinal(:,1) == Level) & (EdgeListFinal(:,2) == 3) & (EdgeListFinal(:,7) == t));
        num_of_pairs = size(IndexHorizontal,1);
        if (num_of_pairs == 0)
            continue;
        end

        x1 = EdgeListFinal(IndexHorizontal,3);
        y1 = EdgeListFinal(IndexHorizontal,4);
        x2 = EdgeListFinal(IndexHorizontal,5);
        y2 = EdgeListFinal(IndexHorizontal,6);
%
        color = (1:1:num_of_pairs);
        h = vision.ShapeInserter;
        release(h);%allows changing ShapeInserter object properties.
        set(h,'Shape','Lines');
        set(h,'BorderColor','Custom');%setting border color to custom.
        set(h,'CustomBorderColor',color);%sets line color,color is an R element vector.
        pts=[x1, y1, x2, y2];
        PixelMap = zeros(size(image));
        PixelMap = step(h,PixelMap,pts);%performs the drawing.
% mask can be changed by introducing convolution    
        for I=1:num_of_pairs
            PixelMap_I = (PixelMap == I);
            ee = max(PixelMap_I*EdgeListFinal(IndexHorizontal(I),8)/ThreshValue(Level),ee);
        end
    end
end


% The rest of the levels contribute reponse and entropy
for Level=MidLevel:-1:StartLevel
    num_of_directions = 2*(2^Level + 1); 
%    
    for t=1:num_of_directions
        IndexVertical = find((EdgeListFinal(:,1) == Level) & (EdgeListFinal(:,2) == 1) & (EdgeListFinal(:,7) == t));
        num_of_pairs = size(IndexVertical,1);
        if (num_of_pairs == 0)
            continue;
        end

        x1 = EdgeListFinal(IndexVertical,3);
        y1 = EdgeListFinal(IndexVertical,4);
        x2 = EdgeListFinal(IndexVertical,5);
        y2 = EdgeListFinal(IndexVertical,6);
%
        color = (1:1:num_of_pairs);
        h = vision.ShapeInserter;
        release(h);%allows changing ShapeInserter object properties.
        set(h,'Shape','Lines');
        set(h,'BorderColor','Custom');%setting border color to custom.
        set(h,'CustomBorderColor',color);%sets line color,color is an R element vector.
        pts=[x1, y1, x2, y2];
        PixelMap = zeros(size(image));
        PixelMap = step(h,PixelMap,pts);%performs the drawing.
% mask can be changed by introducing convolution  
        for I=1:num_of_pairs
            PixelMap_I = (PixelMap == I);
            PixelMap_II = conv2(double(PixelMap_I),[1 1 1 0 0],'same');
            PixelMap_III = conv2(double(PixelMap_I),[0 0 1 1 1],'same');
            h1 = hist(dtheta(PixelMap_II>0),nbins+1);
            h1 = h1 / sum(h1);
            he1 = sum(h1(h1>0).*log(h1(h1>0))); %negative number, closer to zero means more peaked
            h2 = hist(dtheta(PixelMap_III>0),nbins+1);
            h2 = h2 / sum(h2);
            he2 = sum(h2(h2>0).*log(h2(h2>0))); %negative number, closer to zero means more peaked
            ee = max(PixelMap_I*exp(max(he1,he2))*EdgeListFinal(IndexVertical(I),8)/ThreshValue(Level),ee);
        end
    end
    
    for t=1:num_of_directions
        IndexHorizontal = find((EdgeListFinal(:,1) == Level) & (EdgeListFinal(:,2) == 3) & (EdgeListFinal(:,7) == t));
        num_of_pairs = size(IndexHorizontal,1);
        if (num_of_pairs == 0)
            continue;
        end

        x1 = EdgeListFinal(IndexHorizontal,3);
        y1 = EdgeListFinal(IndexHorizontal,4);
        x2 = EdgeListFinal(IndexHorizontal,5);
        y2 = EdgeListFinal(IndexHorizontal,6);
%
        color = (1:1:num_of_pairs);
        h = vision.ShapeInserter;
        release(h);%allows changing ShapeInserter object properties.
        set(h,'Shape','Lines');
        set(h,'BorderColor','Custom');%setting border color to custom.
        set(h,'CustomBorderColor',color);%sets line color,color is an R element vector.
        pts=[x1, y1, x2, y2];
        PixelMap = zeros(size(image));
        PixelMap = step(h,PixelMap,pts);%performs the drawing.
% mask can be changed by introducing convolution    
        for I=1:num_of_pairs
            PixelMap_I = (PixelMap == I);
            PixelMap_II = conv2(double(PixelMap_I),[1 1 1 0 0],'same');
            PixelMap_III = conv2(double(PixelMap_I),[0 0 1 1 1],'same');
            h1 = hist(dtheta(PixelMap_II>0),nbins+1);
            h1 = h1 / sum(h1);
            he1 = sum(h1(h1>0).*log(h1(h1>0))); %negative number, closer to zero means more peaked
            h2 = hist(dtheta(PixelMap_III>0),nbins+1);
            h2 = h2 / sum(h2);
            he2 = sum(h2(h2>0).*log(h2(h2>0))); %negative number, closer to zero means more peaked
            ee = max(PixelMap_I*exp(max(he1,he2))*EdgeListFinal(IndexHorizontal(I),8)/ThreshValue(Level),ee);
        end
    end
    
    
end

%TextureMap = SoftResponsePixelMap .* ee;

if ShowAllFigures
    figure; imagesc(dtheta); axis('image'); title(' theta ','FontSize',14);
end

