% convolution with "mask"
sumabsmask = sum(abs(Params.mask));
convimageVer = convn(image,Params.mask,'same') / sumabsmask;
convimageHor = convn(image,Params.mask','same') / sumabsmask;
% examine EdgeTable
nRes = size(EdgeTable,1);
slopes = zeros(nRes,1);
TL = zeros(nRes,1);
% we should compare to the signed response 
signedRes = EdgeTable(:,9); 
% cases 1-vertical 3-horizontal
vh = EdgeTable(:,2);
% get for each response start and end points (x1,y1), (x2,y2)
% start point
x1 = EdgeTable(:,3);
y1 = EdgeTable(:,4); 
% end point
x2 = EdgeTable(:,5);
y2 = EdgeTable(:,6); 
% Length 
% if vertical the length coincides with y2-y1
% if horizontal the length coincides with x2-x1
L = EdgeTable(:,14); %powers of 2
% calculate slopes 
slopes(vh == 1) = (x2(vh == 1) - x1(vh == 1)) ./ (y2(vh == 1) - y1(vh == 1));
slopes(vh == 3) = (y2(vh == 3) - y1(vh == 3)) ./ (x2(vh == 3) - x1(vh == 3));
% determine potential extended ends (+/- L/4)
x1_ext = x1;
x2_ext = x2;
y1_ext = y1;
y2_ext = y2;
% horizontal
x1_ext(vh==3) = x1_ext(vh==3) - L(vh==3)/4;
x2_ext(vh==3) = x2_ext(vh==3) + L(vh==3)/4;
y1_ext(vh==3) = y1_ext(vh==3) - L(vh==3)/4.*slopes(vh==3);
y2_ext(vh==3) = y2_ext(vh==3) + L(vh==3)/4.*slopes(vh==3);
% vertical
x1_ext(vh==1) = x1_ext(vh==1) - L(vh==1)/4.*slopes(vh==1);
x2_ext(vh==1) = x2_ext(vh==1) + L(vh==1)/4.*slopes(vh==1);
y1_ext(vh==1) = y1_ext(vh==1) - L(vh==1)/4;
y2_ext(vh==1) = y2_ext(vh==1) + L(vh==1)/4;
% corrections
Ic = [find(x1_ext<1)',find(x1_ext>size(image,2))',find(y1_ext<1)',find(y1_ext>size(image,1))',find(x2_ext<1)',find(x2_ext>size(image,2))',find(y2_ext<1)',find(y2_ext>size(image,1))'];
x1_ext(x1_ext<1) = 1;
x1_ext(x1_ext>size(image,2)) = size(image,2);
y1_ext(y1_ext<1) = 1;
y1_ext(y1_ext>size(image,1)) = size(image,1);
x2_ext(x2_ext<1) = 1;
x2_ext(x2_ext>size(image,2)) = size(image,2);
y2_ext(y2_ext<1) = 1;
y2_ext(y2_ext>size(image,1)) = size(image,1);
% total length after extension 
TL(vh==3) = x2_ext(vh==3)-x1_ext(vh==3)+1;
TL(vh==1) = y2_ext(vh==1)-y1_ext(vh==1)+1;
% loop for cross section improfile 
for i=1:nRes
    %i
    if ismember(i,Ic)
        continue;
    end
    shiftSize = L(i)/4+1;
    %[cx,cy,c] = improfile(Response,[x1_ext(i),x2_ext(i)],[y1_ext(i),y2_ext(i)],L(i)+1+L(i)/2);
    if (vh(i) == 1) 
        [cx,cy,c] = improfile(convimageVer,[x1_ext(i),x2_ext(i)],[y1_ext(i),y2_ext(i)],TL(i));
    else
        [cx,cy,c] = improfile(convimageHor,[x1_ext(i),x2_ext(i)],[y1_ext(i),y2_ext(i)],TL(i));
    end
    %{
    aa1 = zeros(size(c,1),1);
    for t1=1:size(c,1)
        aa1(t1) = sum(c(1:t1).^2)+ sum((c(t1+1:end)-signedRes(i)).^2);
    end
    aa2 = zeros(size(c,1),1);
    for t2=1:size(c,1)
        aa2(t1) = sum((c(1:t2)-signedRes(i)).^2)+ sum((c(t2+1:end)).^2);
    end 
    %}
    % localization of the left end
    aa1 = zeros(L(i)/2+1,1);
    for t1=-L(i)/4:L(i)/4
            aa1(t1+shiftSize) = sum(c(1:t1+shiftSize).^2)+ sum((c(t1+1+shiftSize:3*L(i)/4+shiftSize)-signedRes(i)).^2);
    end
    % localization of the right end
    aa2 = zeros(L(i)/2+1,1);
    for t2 = L(i)-L(i)/4:L(i)+L(i)/4
        aa2(t2-L(i)+L(i)/4+1) = sum((c(L(i)/4+shiftSize:t2+shiftSize)-signedRes(i)).^2)+ sum((c(t2+1+shiftSize:5*L(i)/4+shiftSize)).^2);
    end
    % modify edge ends in the table, according to minimal values of aa1 and aa2    
    %left end
    m = min(aa1);
    II = find(aa1 == m);
    t1_opt = max(II)+1-shiftSize;
    if (vh(i) == 1)
        EdgeTable(i,4) = EdgeTable(i,4)+t1_opt;
        EdgeTable(i,3) = EdgeTable(i,3)+t1_opt*slopes(i);
    else
        EdgeTable(i,3) = EdgeTable(i,3)+t1_opt;
        EdgeTable(i,4) = EdgeTable(i,4)+t1_opt*slopes(i);
    end
    % right end
    m = min(aa2);
    II = find(aa2 == m);
    t2_opt = min(II)-1-shiftSize;
    if (vh(i) == 1)
        EdgeTable(i,6) = EdgeTable(i,6)+t2_opt;
        EdgeTable(i,5) = EdgeTable(i,5)+t2_opt*slopes(i);
    else
        EdgeTable(i,5) = EdgeTable(i,5)+t2_opt;
        EdgeTable(i,6) = EdgeTable(i,6)+t2_opt*slopes(i);
    end
end
% drawing
% Accumulate Soft Map of Responses
% first vertical 
for Level=EndLevel:-1:StartLevel 
        num_of_directions = 2*(2^Level + 1);
        for t=1:num_of_directions
            IndexVerticalEdges = find((EdgeTable(:,1) == Level) & (EdgeTable(:,2) == 1) & (EdgeTable(:,7) == t));
            if ~isempty(IndexVerticalEdges)
                x1 = EdgeTable(IndexVerticalEdges,3);
                y1 = EdgeTable(IndexVerticalEdges,4);
                x2 = EdgeTable(IndexVerticalEdges,5);
                y2 = EdgeTable(IndexVerticalEdges,6);    
                % The response is the color  
                color = EdgeTable(IndexVerticalEdges,8) / ThreshValue(Level);
                release(h);%allows changing ShapeInserter object properties.
                set(h,'CustomBorderColor',color);%sets line color,color is an R element vector.

                pts=[x1, y1, x2, y2];
                SoftResponsePixelMap_TMP = zeros(size(image));
                SoftResponsePixelMap_TMP = step(h,SoftResponsePixelMap_TMP,pts);%performs the drawing.
                SoftResponsePixelMap_LE = max(double(SoftResponsePixelMap_LE),double(SoftResponsePixelMap_TMP));
            end
        end
end
% then horizontal
for Level=EndLevel:-1:StartLevel 
        num_of_directions = 2*(2^Level + 1);
        for t=1:num_of_directions
            IndexHorizontalEdges = find((EdgeTable(:,1) == Level) & (EdgeTable(:,2) == 3) & (EdgeTable(:,7) == t));
            if ~isempty(IndexHorizontalEdges)
                x1 = EdgeTable(IndexHorizontalEdges,3);
                y1 = EdgeTable(IndexHorizontalEdges,4);
                x2 = EdgeTable(IndexHorizontalEdges,5);
                y2 = EdgeTable(IndexHorizontalEdges,6);    
                % The response is the color  
                color = EdgeTable(IndexHorizontalEdges,8) / ThreshValue(Level);
                release(h);%allows changing ShapeInserter object properties.
                set(h,'CustomBorderColor',color);%sets line color,color is an R element vector.
                pts=[x1, y1, x2, y2];
                SoftResponsePixelMap_TMP = zeros(size(image));
                SoftResponsePixelMap_TMP = step(h,SoftResponsePixelMap_TMP,pts);%performs the drawing.
                SoftResponsePixelMap_LE = max(double(SoftResponsePixelMap_LE),double(SoftResponsePixelMap_TMP));
            end
        end
end
%
h1 = vision.ShapeInserter;
release(h1);%allows changing ShapeInserter object properties.
set(h1,'Shape','Lines');
set(h1,'BorderColor','White');%draws white color on black image.
x1 = EdgeTable(:,3);
y1 = EdgeTable(:,4);
x2 = EdgeTable(:,5);
y2 = EdgeTable(:,6);
%
pts=[x1, y1, x2, y2];
ResponsePixelMapRefinement = zeros(size(image));
ResponsePixelMapRefinement = step(h1,ResponsePixelMapRefinement,pts);%performs the drawing.
ResponsePixelMapRefinement_overlay=MarkBib2im(image,ResponsePixelMapRefinement);
