-language([evaluate,psifcp,compound,colon]).
-export("RAF").
baserate(1).
global([switchI,raf_mp1,p_ser,ser,atp]).



RAF(env):-
	<< backbone, backbone1, backbone2, backbone2a, backbone3, regulator_bs, atp_bs.
	   RAF_Nt, RAF_ACTIVATOR_BS(env) , RAF_MP1_BS , INACTIVE_RAF_Ct , RAF_ATP_BS .

RAF_Nt:-
	switchI ? {cross_env,cross_ras} | backbone ! {cross_env} | cross_ras ? [] | RAF_Nt .

RAF_ACTIVATOR_BS(env):-
	backbone ? {cross_env} | << cross_env =?= env | RAF_ACTIVATOR_BS(cross_env) ;
				    otherwise | backbone1 ? [] | RAF_ACTIVATOR_BS(cross_env) >> .

INACTIVE_RAF_Ct:- 
	backbone1 ! [] | ACTIVE_RAF_Ct .
	

ACTIVE_RAF_Ct:-
	backbone3 ! [] | backbone2 ? {cross_motif1, cross_motif2} | cross_motif1 ? {cross_res1} | cross_motif2 ? {cross_res2} | 
			 OCCUPIED_RAF_Ct(cross_motif1,cross_motif2,cross_res1,cross_res2) ;
	backbone1 ! [] | INACTIVE_RAF_Ct .

	OCCUPIED_RAF_Ct(cross_motif1,cross_motif2,cross_res1,cross_res2):-  
			cross_res1=?=ser  |  atp_bs ? [] | cross_motif1 ! {p_ser} | 
				OCCUPIED_RAF_Ct(cross_motif1,cross_motif2,p_ser,cross_res2);
			cross_res2=?=ser  |  atp_bs ? [] | cross_motif2 ! {p_ser} | 
				OCCUPIED_RAF_Ct(cross_motif1,cross_motif2,cross_res1,p_ser);
			otherwise  |  backbone2a ! [] | ACTIVE_RAF_Ct .
  
RAF_MP1_BS:-

	backbone3 ? [] | raf_mp1 ? {cross_mp1,cross_mp2} | BOUND_RAF_MP1_BS(cross_mp1,cross_mp2) .

	BOUND_RAF_MP1_BS(site1,site2):-
		site1 ? {cross_motif1, cross_motif2} | backbone2 ! {cross_motif1, cross_motif2} | backbone2a ? [] |
			 site1 ? {cross_motif1, cross_motif2} | site2 ! [] | RAF_MP1_BS ;
		site2 ! [] | RAF_MP1_BS .

RAF_ATP_BS:-
		atp ? {adp} | atp_bs ! [] | adp ! [] | RAF_ATP_BS 

>>
.

	
