-language([evaluate,psifcp,compound,colon]).
-export("MKP1").
baserate(1).
global([athry, tyr,p_tyr,p_thr,atp,mkp1]).


MKP1:-
	<< backbone, backbone2a, atp_bs .
		MKP_BINDING_SITE , MKP_CATALYTIC_CORE .

MKP_BINDING_SITE:-  mkp1 ? {cross_motif1,cross_motif2,cross_bs} | backbone ! {cross_motif1,cross_motif2} |
			backbone2a ? [] | cross_bs ! [] | MKP_BINDING_SITE .

MKP_CATALYTIC_CORE :- 

	ACTIVE_MKP_PHOSPHATASE , MKP_ATP_BS .


ACTIVE_MKP_PHOSPHATASE:-
	backbone ? {cross_motif1, cross_motif2} | cross_motif1 ? {cross_res1} | cross_motif2 ? {cross_res2} | 
			  OCCUPIED_MKP_PHOSPHATASE(cross_motif1, cross_motif2, cross_res1, cross_res2) .
	
	OCCUPIED_MKP_PHOSPHATASE(cross_motif1, cross_motif2,cross_res1,cross_res2):-  
			cross_res1=?=p_thr  |  atp_bs ? [] | cross_motif1 ! {athry} | 
				OCCUPIED_MKP_PHOSPHATASE(cross_motif1,cross_motif2,athry,cross_res2);
			cross_res2=?=p_tyr  |  atp_bs ? [] | cross_motif2 ! {tyr} | 
				OCCUPIED_MKP_PHOSPHATASE(cross_motif1,cross_motif2,cross_res1,tyr);
			otherwise  |  backbone2a ! [] | ACTIVE_MKP_PHOSPHATASE .
  

MKP_ATP_BS:-
	atp ? {adp} | atp_bs ! [] | adp ! [] | MKP_ATP_BS 


>>
