-language([evaluate,psifcp,compound,colon]).
-export("RTK").
baserate(1).
global([ligand_bind,tyr,p_tyr,met,atp,dummy]).


RTK(env):-

	<< backbone_extra, backbone_intra1, backbone_intra2, backbone_intra3, tyr1162, atp_bs, sh2_tyr , sh2_tyr1 . 
	   EXTRACELLULAR , TRANSMEMBRANAL , INTRACELLULAR .

EXTRACELLULAR:- 
	ligand_bind ? {ligand1,ligand2} | backbone_extra ! {ligand1,ligand2} | BOUND_EXTRACELLULAR .

	BOUND_EXTRACELLULAR:- 
		dummy ? [] | true .
TRANSMEMBRANAL:-
	backbone_extra ? {cross_ligand1,cross_ligand2} | RTK_DIMERIZATION(cross_ligand1,cross_ligand2) .

RTK_DIMERIZATION(cross_ligand1,cross_ligand2):-
	cross_ligand1 ! {tyr1162}  | cross_ligand2 ? {cross_tyr} | backbone_intra1 ! {cross_tyr} | RTK_DIMERIZED ;
	cross_ligand2 ? {cross_tyr}| cross_ligand1 ! {tyr1162}   | backbone_intra1 ! {cross_tyr} | true .

RTK_DIMERIZED:-
	dummy ? [] | true .
	
INTRACELLULAR:-
	RTK_SH_BS(tyr,met), RTK_KINASE_CORE .

RTK_KINASE_CORE:-
	RTK_KINASE_SITE , RTK_REGULATORY_SITE(tyr) ,  RTK_ATP_BS   .

	RTK_KINASE_SITE:-
		CROSS_PHOSPHORYLATE + FULL_PHOSPHORYLATE .

	CROSS_PHOSPHORYLATE:-
		backbone_intra1 ? {cross_motif} | cross_motif ? {cross_res} | 
			<< cross_res=?=tyr  |  atp_bs ? [] | cross_motif ! {p_tyr} | RTK_KINASE_SITE ;
		 	   otherwise | cross_motif ! {cross_res} | RTK_KINASE_SITE >> . 

	FULL_PHOSPHORYLATE:-
		backbone_intra3 ? [] | ACTIVE_FULL .

	ACTIVE_FULL:-
		backbone_intra2 ? {cross_motif} | cross_motif ? {cross_res} | 
			<< cross_res=?=tyr  |  atp_bs ? [] | cross_motif ! {p_tyr} | ACTIVE_FULL ;	         				 	 	   otherwise | cross_motif ! {cross_res} | ACTIVE_FULL >> ;
		backbone_intra3 ? [] | RTK_KINASE_SITE .

	RTK_REGULATORY_SITE(res):-
		tyr1162 ! {res} | tyr1162 ? {res1} | << res1 =?= res  | RTK_REGULATORY_SITE(res1) ;
							otherwise | backbone_intra3 ! [] | RTK_REGULATORY_SITE(res1) >> . 

	RTK_SH_BS(res,res1):-
		backbone_intra2 ! {sh2_tyr} | sh2_tyr ! {res} | sh2_tyr ? {resa} | RTK_SH_BS(resa,res1) ;
		res ! {sh2_tyr, sh2_tyr1, backbone_intra2, env, res1} | << sh2_tyr1 ? [] | BOUND_RTK_SH_BS ;
									  sh2_tyr ? {res1} | RTK_SH_BS(res,res1) >>.

		BOUND_RTK_SH_BS:-
			dummy ? [] | true . 
		

	RTK_ATP_BS:-
		atp ? {adp} | atp_bs ! [] | adp ! [] | RTK_ATP_BS 


>>
.

	
		
				     



