-language([evaluate,psifcp,compound,colon]).
-export("MEK1").
baserate(1).
global([athry, mek_mp1,p_ser,ser,tyr,p_tyr,p_thr,atp]).


MEK1:-
	<< backbone, backbone1, backbone2, backbone2a, backbone3,  ser_motif1, ser_motif2, atp_bs .
		MEK_MP1_BS , MEK_CATALYTIC_CORE .

MEK_MP1_BS :- 
	backbone2 ? [] | mek_mp1 ? {cross_mp1,cross_mp2,cross_mp3} | MEK_BOUND_MP1_BS(cross_mp1,cross_mp2,cross_mp3) .

	MEK_BOUND_MP1_BS(site1,site2,site3):-
		backbone2 ? [] | site1 ! {ser_motif1, ser_motif2} | site1 ! {ser_motif1, ser_motif2} | 
			MEK_BOUND_MP1_BS(site1,site2,site3);
		backbone3 ? [] | site2 ? {cross_motif1, cross_motif2} | backbone ! {cross_motif1, cross_motif2} | backbone2a ? [] | 
			site2 ? {cross_motif1, cross_motif2} |  MEK_BOUND_MP1_BS(site1,site2,site3).

MEK_CATALYTIC_CORE :- 

	MEK_LIP(ser,ser) , INACTIVE_MEK_KINASE , MEK_ATP_BS .

MEK_LIP(res1,res2):-
	ser_motif1 ! {res1}  | ser_motif2 ! {res2}  | OCCUPIED_MEK_LIP(res1,res2) .

OCCUPIED_MEK_LIP(res1,res2):-
	 ser_motif1 ? {res1a} | << res1a=?=p_ser & res2=?=p_ser | backbone1 ! [] | MEK_LIP(res1a,res2);
	 			   res1a=?=ser & res2=?=ser | backbone1 ! [] | MEK_LIP(res1a,res2);
				   otherwise | OCCUPIED_MEK_LIP(res1a,res2) >> ;
	 ser_motif2 ? {res2a} | << res1=?=p_ser & res2a=?=p_ser | backbone1 ! [] | MEK_LIP(res1,res2a);
 				   res1=?=ser & res2a=?=ser | backbone1 ! [] | MEK_LIP(res1,res2a);
				   otherwise | OCCUPIED_MEK_LIP(res1,res2a) >> .

INACTIVE_MEK_KINASE:-
	backbone1 ? [] | ACTIVE_MEK_KINASE ;
	backbone2 ! [] | INACTIVE_MEK_KINASE .

ACTIVE_MEK_KINASE:-
	backbone3 ! [] | backbone ? {cross_motif1, cross_motif2} | cross_motif1 ? {cross_res1} | cross_motif2 ? {cross_res2} | 
			  OCCUPIED_MEK_KINASE(cross_motif1,cross_motif2,cross_res1,cross_res2) ;
	backbone1 ? [] |  INACTIVE_MEK_KINASE .
	
	OCCUPIED_MEK_KINASE(cross_motif1,cross_motif2,cross_res1,cross_res2):-  
			cross_res1=?=athry  |  atp_bs ? [] | cross_motif1 ! {p_thr} | 
				OCCUPIED_MEK_KINASE(cross_motif1,cross_motif2,p_thr,cross_res2);
			cross_res2=?=tyr  |  atp_bs ? [] | cross_motif2 ! {p_tyr} | 
				OCCUPIED_MEK_KINASE(cross_motif1,cross_motif2,cross_res1,p_tyr);
			otherwise  |  backbone2a ! [] | ACTIVE_MEK_KINASE .
  

MEK_ATP_BS:-
		atp ? {adp} | atp_bs ! [] | adp ! [] | MEK_ATP_BS 
		

	>>
.

































