-language([evaluate,psifcp,compound,colon]).
-export("AP1_PROTEIN","AP1_GENE").
baserate(1).
global([pAP1,athry,ap1,ap1p,ap1_site,p_thr,ser,p_ser,dummy,deg1(0.1)]).


AP1_PROTEIN(env):- 
	<<backbone,ap1_motif1,ap1_motif2 . INACTIVE_AP1(athry,ser) .

INACTIVE_AP1(res1,res2):-

	ap1 ! {ap1_motif1,ap1_motif2} | AP1_REGULATORY_DOMAIN(res1,res2) ;
	deg1 ? [] | true .


AP1_REGULATORY_DOMAIN(res1,res2):-

	ap1_motif1 ! {res1} | ap1_motif2 ! {res2} | OCCUPIED_REGULATORY_DOMAIN(res1,res2) .

	OCCUPIED_REGULATORY_DOMAIN(res1,res2):-
		ap1_motif1 ? {res1a} | OPTION1(res1a,res2) ;
		ap1_motif2 ? {res2a} | OPTION2(res1,res2a) .


OPTION2(res1,res2a):-
	  res1=?=p_thr & res2a=?=p_ser |  ACTIVE_AP1(res1,res2a);
	  res1=?=athry & res2a=?=ser |  INACTIVE_AP1(res1,res2a) ;
	  otherwise | OCCUPIED_REGULATORY_DOMAIN(res1,res2a) .

OPTION1(res1a,res2):-
	  res1a=?=p_thr & res2=?=p_ser |  ACTIVE_AP1(res1a,res2) ;
  	  res1a=?=athry & res2=?=ser | INACTIVE_AP1(res1a,res2) ;
   	  otherwise | OCCUPIED_REGULATORY_DOMAIN(res1a,res2) .

ACTIVE_AP1(res1,res2):-
	ap1_site ! [] | ACTIVE_AP1 ;
	ap1p ! {ap1_motif1,ap1_motif2} | AP1_REGULATORY_DOMAIN(res1,res2) ;
	deg1 ? [] | true 
	

	>> .

AP1_GENE(env):-
	pAP1 ? [] | AP1_GENE(env), AP1_PROTEIN(env) .	

 


