function [Hmms, times] = ExpOneRunAlias(  data,   NumOfStates, NumComp,  hmm, Algs, fileToSaveData)
%%%%%%%
[ runBW , runEM, runMomExact, runMomEM, runMomExactBW, runMomEMBW,  runExactBW, runEMBW ] = deal( Algs{:} );
global TolBW; global IterBW
global TolEM; global IterEM;
global TolQP;global IterQP;
TolBW =  1e-12;  IterBW =20;
TolEM = size(data,2) * 1e-10;  IterEM = 500; % opt -10
TolQP = 1e-18;  IterQP = 100000; % opt - 18
%%%%%%%
hmmG = hmm;
global NumOfSamples;
global cNumOfStates;
global obsLength;
global modelInitFileName;
global NumOfViews
global NumOfComp
tic
% Default values, might change during run.
NumOfSamples =size( data, 2);
obsLength = size( data, 1);
cNumOfStates = NumOfStates;
NumOfViews = 3; % for now Don't Change!
NumOfComp = NumComp;
modelInitFileName =  strcat( 'model_init_',num2str( cNumOfStates ) ,'.txt');

hmmBW = [];
hmmEM = [];
hmmMomExact = [];
hmmMomEM  = [];
hmmMomExactBW = [];
hmmMomEMBW = [];
hmmExactBW = [];
hmmEMBW = [];

times = zeros(1,length( Algs)+1 );
algcount = 1;

%%%%%%%%%
% run BW
algcount = algcount+1;
hmmBW = [];
if runBW
    fprintf('running BW...\n ');
    t1 = tic;
    hmmInitial = AliasGHMM( [] , [] , [] , [], [], [], [], [] );
    hmmInitial.numComp = NumOfComp;
    hmmBW = LearnBW(data, hmmInitial, NumOfStates); % [] for no prior information
    times( algcount ) = toc(t1);
    if ~isempty( hmmG ) && ~isempty( hmmBW )
        hmmBW = hmmBW.matchHmmToHmm(hmmG);
    end
end
%%%%%%%%%%

%%%%%%%%%%
% run EM
algcount = algcount+1;
hmmEM = [];
if runEM
    fprintf('running EM...\n');
    trails = 3;
    bestLlh = -Inf;
    i = 0;
    while  i < trails
        i = i+1;
        [label, model, llh] = emgm(data,NumComp);
        if size(model.mu,2) ~= NumComp
            i = i-1;
        end
        if(max(llh) > bestLlh && size(model.mu,2) == NumComp)
            cModel = model;
            bestLlh = max(llh);
        end
    end
    mu = cModel.mu;
    sigma = reshape( sqrt(cModel.Sigma), 1,length(mu) );
    compWeights = cModel.weight;
    
    if ~isempty( hmmG )
        [cV, cnorm,perm, Matching] = bestPermVec2(hmmG.mu', mu');
        mu =  mu * Matching
        sigma =   sigma * Matching;
        compWeights = compWeights * Matching;
    end
    hmmEM =  AliasGHMM([],[],[], mu, sigma, compWeights',[], []);
else
    %hmmEM = hmmSP;
    %hmmEM = hmmG;
end
%%%%%%%%%%

hmmExact = AliasGHMM([],[],[], hmmG.mu, hmmG.sigma, hmmG.compWeights,[], []);
%%%%%%%%%%%%
% Exact +  MoM
algcount = algcount+1;
hmmMomExact = [];
if runMomExact
    fprintf('running MoM + Exact...\n');
    t1=tic;
    hmmMomExact = hmmExact.learnAliasA( data );
    if ~isempty( hmmG )
        hmmMomExact = hmmMomExact.matchHmmToHmm(hmmG);
    end
    times( algcount ) = toc(t1);
end
%%%%%%%%%%%%

%%%%%%%%%%%%
% EM +  MoM
algcount = algcount+1;
hmmMoMEM = [];
if runMomEM
    t1=tic;
    fprintf('running EM + MoM...\n');
    hmmMomEM = hmmEM.learnAliasA( data );
    if ~isempty( hmmG ) && (hmmG.n == hmmMomEM.n)
        hmmMomEM = hmmMomEM.matchHmmToHmm(hmmG);
    end
    times( algcount ) = toc(t1);
end
%%%%%%%%%%%%

%%%%%%%%%%
% MoM + Exact + BW
algcount = algcount+1;
if runMomExactBW
    t1 = tic;
    fprintf('running BW with MoM + Exact...\n');
    hmmMomExactBW = LearnBW(data, hmmMomExact, NumOfStates);
    if ~isempty( hmmG )
        hmmMomExactBW = hmmMomExactBW.matchHmmToHmm(hmmG);
    end
    times( algcount ) = toc(t1);
end
%%%%%%%%%%

%%%%%%%%%%
% MoM + EM + BW
algcount = algcount+1;
hmmMomEMBW = [];
if runMomEMBW
    t1 = tic;
    fprintf('running BW with MoM + EM...\n');
    hmmMomEMBW = LearnBW(data, hmmMomEM, NumOfStates);
    if ~isempty( hmmG )
        hmmMomEMBW = hmmMomEMBW.matchHmmToHmm(hmmG);
    end
    times( algcount ) = toc(t1);
end
%%%%%%%%%%

%%%%%%%%%%
% Exact + BW
algcount = algcount+1;
hmmExactBW = [];
if runExactBW
    t1 = tic;
    fprintf('running BW with Exact...\n');
    hmmExactBW = LearnBW(data, hmmExact, NumOfStates);
    if ~isempty( hmmG )
        hmmExactBW = hmmExactBW.matchHmmToHmm(hmmG);
    end
    times( algcount ) = toc(t1);
end
%%%%%%%%%%

%%%%%%%%%%
% EM + BW
algcount = algcount+1;
hmmEMBW = [];
if runEMBW
    t1 = tic;
    fprintf('running BW with EM...\n');
    hmmEMBW = LearnBW(data, hmmEM, NumOfStates);
    if ~isempty( hmmG )
        hmmEMBW = hmmEMBW.matchHmmToHmm(hmmG);
    end
    times( algcount ) = toc(t1);
end
%%%%%%%%%%

%%%%%%%%%%
Hmms = {hmmG, hmmBW, hmmEM, hmmMomExact, hmmMomEM, hmmMomExactBW, hmmMomEMBW, hmmExactBW, hmmEMBW} ;
toc;
end


function hmmBW = LearnBW(data, hmmKnown, NumOfStates)
global TolBW; global IterBW;
trails = 1;
bestLlh = -Inf;
for i = 1:trails
    O = 1;
    M = 1;
    n = NumOfStates;
    clear LL;
    prior0 = normalise(ones( NumOfStates , 1));
    if isempty(hmmKnown.A)
        transmat0 = mk_stochastic( rand( NumOfStates, NumOfStates) );
    else
        transmat0 = hmmKnown.A;
    end
    [mu0, Sigma0, w0] = mixgauss_init(hmmKnown.numComp*M, reshape(data, [O size( data,2) ]), 'diag');
    if ~isempty(hmmKnown.mu)
        mu0 = hmmKnown.mu; %[ -3 -3 0 3];
    end
    if ~isempty(hmmKnown.sigma)
        Sigma0 = hmmKnown.sigma; %[ -3 -3 0 3];
    end
    left_right = 0;
    sigma0 = reshape( Sigma0, [1 hmmKnown.numComp] ) ;
    mu0 = [mu0(1) mu0]; %%%%%%%%%% ASSUMING aliasing comp is 1 with order 1
    sigma0 = [ sigma0(1) sigma0]; %%%%%%%%%% ASSUMING aliasing comp is 1 with order 1
    mu0 = reshape(mu0, [O n M]);
    Sigma0 = reshape(sigma0, [O O n M]);
    mixmat0 =ones(n,M);% mk_stochastic(rand(Q,M));
    [LL, prior1, transmat1, mu1, Sigma1, mixmat1] = ...
        mhmm_em(data, prior0, transmat0, mu0, Sigma0, mixmat0, 'max_iter', IterBW, 'thresh', TolBW);
    maxLL =max(LL);
    if( maxLL > bestLlh)% && maxLL <=0 )
        cprior = prior1;
        ctransmat =  transmat1;
        cmu = mu1;
        cSigma = Sigma1;
        bestLlh = maxLL;
        bestLlh = maxLL;
    end
end
compWeights = [];
sToC = [1:n];
hmmSigma = reshape( Sigma1, [1, n] );
hmmBW = AliasGHMM(n,transmat1' , sToC , mu1 ,hmmSigma , compWeights ,prior1 , []);
end


function A = qp_BerMix( data, B, w ) % run the QP for estimating A
global cNumOfStates;
global ObsLength;
global TolQP; global IterQP;
hmm = BernoulliHMM( cNumOfStates, [ ], ObsLength, B, [ ], w );
A = hmm.estimateTransition(data, TolQP, IterQP);
end


function data = generateSyntheticData(hmm)
global NumOfSamples;
[~,data] = hmm.generateSamples(NumOfSamples);
end
