function ghmm = estimateGHMM( data, n)
% Estimate a Gaussian HMM with n number of states from data 
% In the estimation process, first the output parameters are estimated by
% fitting a mixture model to the data, using the EM algorithm. The code for the EM algorithm is taken from the Matlab Package
% "EM_GM_Fast" (which is included in the current folder and is available online at matlab.com).
% Next the transition matrix is estimated by solving a quadradic program
%
[mu, sigma, compWeights] = estimateOutputParametersGHMM( data, n );
A = estimateTransitionMatrixGHMM(data, mu, sigma, compWeights');
ghmm = AliasGHMM.NonAliasGHMMe(n, A , mu, sigma, compWeights);
end
