function [mu, sigma, compWeights] = estimateOutputParametersGHMM( data, NumComp )
    fprintf('running EM...\n');
    trails = 4;
    bestLlh = -Inf;
    i = 0;
    while  i < trails
        i = i+1;
        [label, model, llh] = emgm(data,NumComp);
        if size(model.mu,2) ~= NumComp
            i = i-1;
        end
        if(max(llh) > bestLlh && size(model.mu,2) == NumComp)
            cModel = model;
            bestLlh = max(llh);
        end
    end
    mu = cModel.mu;
    sigma = reshape( sqrt(cModel.Sigma), 1,length(mu) );
    compWeights = cModel.weight;
end