function processStatistics( Err, Loglik, Time, NumOfStatesVec, NumCompVec, NumOfSamplesVec, NumOfAlgs, AlgsNames, Algs, NumOfRuns)
% average over runs %%%
if isempty( NumOfRuns )
    NumOfRuns = max(1 , find( cellfun( @isempty, Err ) , 1, 'first')  - 2 );
end
ErrA = zeros( length( NumOfStatesVec ), length( NumCompVec ),   length( NumOfSamplesVec ), NumOfAlgs);
ErrB = zeros( length( NumOfStatesVec ), length( NumCompVec ),   length( NumOfSamplesVec ), NumOfAlgs );
LogLik = zeros( length( NumOfStatesVec ), length( NumCompVec ),   length( NumOfSamplesVec ), NumOfAlgs );
Times = zeros( length( NumOfStatesVec ), length( NumCompVec ),   length( NumOfSamplesVec ), NumOfAlgs );

for statesInd = 1 : length( NumOfStatesVec )
    for observInd = 1 : length( NumCompVec )
        for numOfSamplesInd = 1 : length( NumOfSamplesVec )
            for run = 1 : NumOfRuns
                ErrAt = cell2mat(Err{run,statesInd,observInd, numOfSamplesInd }{1} );
                ErrBt = cell2mat(Err{run,statesInd,observInd, numOfSamplesInd}{2} );
                Loglikt = cell2mat( Loglik{run,statesInd,observInd, numOfSamplesInd} );
                Timest = cell2mat( Time{run,statesInd,observInd, numOfSamplesInd} );
                for alg = 1 : NumOfAlgs
                    ErrA( statesInd, observInd, numOfSamplesInd, alg ) = ErrA( statesInd, observInd, numOfSamplesInd, alg ) + ErrAt(alg);
                    ErrB( statesInd, observInd, numOfSamplesInd, alg ) = ErrB( statesInd, observInd, numOfSamplesInd, alg ) + ErrBt(alg);
                    LogLik( statesInd, observInd, numOfSamplesInd, alg ) =  LogLik( statesInd, observInd, numOfSamplesInd, alg ) + Loglikt(alg);
                    Times( statesInd, observInd, numOfSamplesInd, alg ) =  Times( statesInd, observInd, numOfSamplesInd, alg ) + Timest(alg);
                end
            end
        end
    end
end
ErrA = ErrA / NumOfRuns;
ErrB = ErrB / NumOfRuns;
LogLik = LogLik / NumOfRuns;
Times = Times / NumOfRuns;
% make plots %%
ErrAresh = reshape( ErrA(1, 1, :, :) , [ length( NumOfSamplesVec ), NumOfAlgs  ] );
ErrBresh = reshape( ErrB(1, 1, :, :) , [ length( NumOfSamplesVec ), NumOfAlgs  ] );
Loglikresh = reshape( LogLik(1, 1, :, :) , [ length( NumOfSamplesVec ), NumOfAlgs  ] );
Timesresh = reshape( Times(1, 1, :, :) , [ length( NumOfSamplesVec ), NumOfAlgs  ] );

%plot 1 setings %%%
figure(1); clf;
activeAlg = find( cell2mat(Algs)  ) +1;
hold on
markers = ['o','s','d','^','>','<','*','d','^'];
colors = ['b','g','r','m','y','c','k','b','g'];
for i = 1:length(activeAlg)
    plot( NumOfSamplesVec,  ErrAresh( : , activeAlg(i) ), 'Marker', markers(i), 'color', colors(i));
end
leg = legend( AlgsNames( activeAlg )' );
axis([min(NumOfSamplesVec) max(NumOfSamplesVec)  3*10^-3 1]);
set(gca,'Box','on');
set(gca,'Box','on');
set(gca,'fontsize',22,'LineWidth',1);
set(gca,'xscale','log','yscale','log');
xlabel('sample size $T$','Interpreter','LaTex','fontsize',25);
ylabel('$${\bf E}|| \hat{A} - A||_F^2$$','Interpreter','LaTex','fontsize',25);
set(gca,'XTick',[10^2  10^3 10^4 10^5 10^6]);
hline = findobj(gcf, 'type', 'line');
for i = 1:1:size(hline,1)
    set(hline(i),'LineWidth',3,'MarkerFaceColor',get(hline(i),'color'),'MarkerSize',10);
end
set(leg,'fontsize',20,'location','southwest','box','off');
grid on;
grid minor;
print('errorVsSample','-dpng');
%print -depsc errorVsSample.eps;

%plot 2 setings %%%
figure(2); clf;
activeAlg = find( cell2mat(Algs)  ) + 1;
TimesAcum = Timesresh;
TimesAcum(:,6) = TimesAcum(:,6) + TimesAcum(:,4);
hold on
for i = 1:length(activeAlg)
    plot( NumOfSamplesVec,  TimesAcum( : , activeAlg(i) ), 'Marker', markers(i), 'color', colors(i));
end
leg = legend( AlgsNames( activeAlg )' );
axis([min(NumOfSamplesVec) max(NumOfSamplesVec)  0 200]);
set(gca,'Box','on');
set(gca,'fontsize',22,'LineWidth',1);
xlabel('sample size $T$','fontsize',25,'Interpreter','LaTex');
ylabel('running time (secs)','fontsize',25,'Interpreter','LaTex');
set(gca,'XTick',[0  10^5 2*10^5 3*10^5 4*10^5 5*10^5]);
hline = findobj(gcf, 'type', 'line');
for i = 1:size(hline,1)
    set(hline(i),'LineWidth',3,'MarkerFaceColor',get(hline(i),'color'),'MarkerSize',10);
end
set(leg,'fontsize',20,'location','northwest','box','off');
grid on;
print('timeVsSample','-dpng');
%print -depsc timeVsSample.eps;

if 0
    figure(3) ; clf;
    plot( NumOfSamplesVec, ErrBresh(  : , 2 : end ) , 'o-')
    axis([10^2 10^6  0 .2])
    set(gca,'Box','on');
    set(gca,'fontsize',20,'LineWidth',1);
    set(gca,'xscale','log','yscale','linear');
    xlabel('number of samples','fontsize',20);
    ylabel('$${\bf E}|| \hat{B} - B||_F^2$$','Interpreter','LaTex','fontsize',20);
    set(gca,'XTick',[10^2  10^3 10^4 10^5 10^6]);
    set(gca,'YTick',[10^-3 10^-2 10^-1 10^-0 10^1 ]);
    hline = findobj(gcf, 'type', 'line');
    for i = 1:size(hline,1)
        set(hline(i),'LineWidth',3,'MarkerFaceColor',get(hline(i),'color'),'MarkerSize',4);
    end
    grid on;
    grid minor;
    %print -depsc ErrB4S20O.eps;
    drawnow
end
end