function ExpRunAliasSim()
clear
addpath(genpath('.\HMMtoolbox'))
addpath(genpath('.\emgm'))
% Algs to run:  %%%% set 1 to run algorithm
[ runBW, runEM, runMomExact, runMomEM, runMomExactBW, runMomEMBW, runExactBW, runEMBW] = deal...
    ( 0    , 0    , 1          , 0       , 1            , 0         , 1         , 0      );
%Algs =   { runBW , runSP, runEM, runSPEM, runSPQP, runEMQP, runSPEMQP, runSPQPBW,  runAliasBW, runSPEMQPBW};
Algs =   { runBW, runEM, runMomExact, runMomEM, runMomExactBW, runMomEMBW,  runExactBW, runEMBW};
AlgsNames = {'Gen', 'BW', 'EM', 'MoM+exact', 'MoM+EM', 'BW+MoM+exact' ,'BW+MoM+EM', 'BW+exact', 'BW+EM'};
NumOfAlgs = length(Algs) + 1; % +1  for HmmG - the data generating HMM, which is in the 1-st index
% Saving/Loading data %%%%%%%%
loadDataFromSavedWS = 0;
sampleReadFileName = 'sampleTest';
fileToSaveData = sampleReadFileName;
%%%%%%%%%%%%
sd = 7245; rng(sd) % set seed for random 
%%%%%%%%%%%%
NumOfRuns = 100; % number of independent runs. Each run generates an independent sequence from the genereting HMM
NumOfStatesG = 4; % number of states in the genereting HMM
NumOfViews = 3; % when using Anandkumar 2012 spectral method to learn the mixture
NumCompG = 3; % number of unique output distributions in the genereting HMM. Set as NumOfStatesG for non-aliased HMM and NumOfStatesG-1 for 2-aliased HMM
%%%%%%%%%%%%
TotalNumOfSamples = 100000; % total length of sequence generated
TrainNumOfSamples =  TotalNumOfSamples; % length of sequence used for training
TestNumOfSamples = TotalNumOfSamples - TrainNumOfSamples; % length of sequence used for testing
NumOfStatesVec = [NumOfStatesG];
NumOfSamplesVec = floor( TrainNumOfSamples * [...
    0.01, ...
    0.02, ...
    0.04, ...
    0.1, ...
    0.2, ...
    0.4, ...
    1 ...
    ] );
NumCompVec = [NumCompG];
% statistics %
global RHmms;
global HmmGs;
global Err;
global Loglik;
global Time;
Err = cell( NumOfRuns, length( NumOfStatesVec ), length( NumCompVec ),   length( NumOfSamplesVec ));
% syntax: Err( run, alg, states, obsLength, )
Loglik = cell( NumOfRuns, length( NumOfStatesVec ), length( NumCompVec ),   length( NumOfSamplesVec ));
Time = cell( NumOfRuns, NumOfAlgs, length( NumOfStatesVec ), length( NumCompVec )  );
RHmms = cell(NumOfRuns, 6 ); % hmmG, hmmBW, hmmSP, hmmEM, hmmSPEM,  hmmBWwI
HmmGs = cell( NumOfRuns, 1);

% loop %
hmmG = [];
hmmG = AliasGHMM.generateAliasHMM( NumOfStatesG, NumCompG );
for run = 1 : NumOfRuns
    fprintf('run %d / %d\n', run, NumOfRuns);
    fprintf('drawing synthetic data...\n');
    if ~loadDataFromSavedWS % Locks the seed for pathological cases by hand
        [dataStates, data] = generateSyntheticData(hmmG, TotalNumOfSamples);
    else
        load( wsDataHmmGsdFileName, 'sd', 'data', 'dataStates', 'hmmG' );
        rng(sd) % set seed for random
    end
    trainData = data( : , 1 : TrainNumOfSamples );
    trainDataStates = dataStates(: , 1 : TrainNumOfSamples );
    testData = data(  :, TrainNumOfSamples+1:end );
    testDataStates = dataStates(  :, TrainNumOfSamples+1:end );
    %%%%%
    statesInd = 1;
    for numOfSamples = 1 : length( NumOfSamplesVec )
        fprintf('run: %d/%d, samples %d / %d\n', run, NumOfRuns, NumOfSamplesVec( numOfSamples ) , TrainNumOfSamples);
        for numCompInd = 1 : length( NumCompVec )
            [dataTrun, hmmGTrun] = truncateDataModel( trainData, hmmG, NumOfSamplesVec( numOfSamples ), TrainNumOfSamples, NumCompVec( numCompInd ), NumCompG, NumOfViews );
            [CHmms, times] =  ExpOneRunAlias(  dataTrun, NumOfStatesG, NumCompG, hmmGTrun, Algs, fileToSaveData);
            updateStatistics(CHmms, run, statesInd, numCompInd, numOfSamples, testData, testDataStates, times );
        end
        %save( wsFileName );
    end
    processStatistics( Err, Loglik,Time, NumOfStatesVec, NumCompVec, NumOfSamplesVec, NumOfAlgs, AlgsNames, Algs, run )
end
end

function [ dataTrun, HmmGTrun ] = truncateDataModel( data, hmmG, newNumOfSamples, NumOfSamplesG, newObsLength, ObsLengthG, NumOfViews)
dataTrun = data(:, 1: newNumOfSamples );
HmmGTrun = hmmG;
end

function updateStatistics(CHmms, run, statesInd, observInd, numOfSamplesInd, dataTest, dataTestStates, time )
global Err;
global Loglik;
global Time;
global RHmms;
global HmmGs;
for i = 1 : length( CHmms )
    if isempty( CHmms{i} )
        CErrA{i} = Inf;
        CErrB{i} = Inf;
        CLoglik{i} = -Inf;
        CTime{i} = Inf;
    else
        if ~isempty ( CHmms{i}.A )
            if i == 1 && numOfSamplesInd > 1
                CErrA{i} = cell2mat( Err{run,statesInd,observInd, numOfSamplesInd - 1}{1}( 1 ) ); % saving time of calculating error for hmmG
            else
            end
            CErrA{i} = norm( CHmms{i}.A - CHmms{1}.A , 'fro' );
        else
            CErrA{i} = Inf;
        end
        CErrB{i} = Inf;% norm( CHmms{i}.B - CHmms{1}.B , 'fro' );
        
        CLoglik{i} = -Inf;% CHmms{i}.calculateLoglik( dataTest );
        
        CTime{i} = time(i);
    end
end
CErr = {CErrA, CErrB};
Err{run,statesInd,observInd, numOfSamplesInd} = CErr;
Loglik{run,statesInd,observInd, numOfSamplesInd} = CLoglik;
Time{run,statesInd,observInd, numOfSamplesInd} = CTime;
RHmms{run,statesInd, observInd, numOfSamplesInd} = CHmms;
HmmGs{run} = CHmms{1};
end

function [dataStates, data] = generateSyntheticData(hmm, NumOfSamples)
[dataStates,data] = hmm.generateSamples(NumOfSamples);
end
