function ExpRunSim()
% Run an experiment for fitting a distcret space HMM with univariate Gaussian output distributions
%
clear
addpath(genpath('.\HMMtoolbox'))
% Algs to run:  %%%% set 1 to run algorithm
[ runBW, runEM, runMomExact, runMomEM, runMomExactBW, runMomEMBW, runExactBW, runEMBW] = deal...
    ( 0    , 0    , 1          , 0       , 1            , 0         , 1         , 0      );
%Algs =   { runBW , runSP, runEM, runSPEM, runSPQP, runEMQP, runSPEMQP, runSPQPBW,  runAliasBW, runSPEMQPBW};
Algs =   { runBW, runEM, runMomExact, runMomEM, runMomExactBW, runMomEMBW,  runExactBW, runEMBW};
AlgsNames = {'Gen', 'BW', 'EM', 'QP+exact', 'QP+EM', 'BW+QP+exact' ,'BW+QP+EM', 'BW+exact', 'BW+EM'};
NumOfAlgs = length(Algs) + 1; % +1  for HmmG - the data generating HMM, which is in the 1-st index
%%%%%%%%%%%%
sd = 7245; rng(sd) % set seed for random %72451
%%%%%%%%%%%%
sampleReadFileName = 'sampleTest';
fileToSaveData = sampleReadFileName;
%%%%%%%%%%%%
NumOfRuns = 100; % number of independent runs. Each run generates an independent sequence from the genereting HMM
NumOfStatesG = 4; % number of states in the genereting HMM
NumOfViews = []; % when using Anandkumar 2012 spectral method to learn the mixture
NumCompG = NumOfStatesG; % number of unique output distributions in the genereting HMM. Set as NumOfStatesG for non-aliased HMM and NumOfStatesG-1 for 2-aliased HMM
%%%%%%%%%%%%
TotalNumOfSamples = 100000; % total length of sequence generated
TrainNumOfSamples =  TotalNumOfSamples; % length of sequence used for training
NumOfStatesVec = [NumOfStatesG]; % what different number of states should the algorithm try to fit -- currently as the generating
NumOfSamplesVec = floor( TotalNumOfSamples * [...
    0.01, ...
    0.02, ...
    0.04, ...
    0.1, ...
    0.2, ...
    0.4, ...
    1 ...
    ] ); % different number of samples used in the experiment
NumCompVec = [NumCompG]; % different number of components to consider - for non-aliased HMM set as NumOfStatesG
% statistics %
global RHmms;
global HmmGs;
global Err;
global Loglik;
global Time;
Err = cell( NumOfRuns, length( NumOfStatesVec ), length( NumCompVec ),   length( NumOfSamplesVec ));
% syntax: Err( run, alg, states, obsLength, )
Loglik = cell( NumOfRuns, length( NumOfStatesVec ), length( NumCompVec ),   length( NumOfSamplesVec ));
Time = cell( NumOfRuns, NumOfAlgs, length( NumOfStatesVec ), length( NumCompVec )  );
RHmms = cell(NumOfRuns, 6 ); % hmmG, hmmBW, hmmSP, hmmEM, hmmSPEM,  hmmBWwI
HmmGs = cell( NumOfRuns, 1);

% loop %
hmmG = [];
hmmG = AliasGHMM.generateNonAliasHMM( NumOfStatesG, NumCompG ); % the genereting HMM
for run = 1 : NumOfRuns
    fprintf('run %d / %d\n', run, NumOfRuns);
    fprintf('drawing synthetic data...\n');
    [dataStates, data] = generateSyntheticData(hmmG, TotalNumOfSamples);
    trainData = data( : , 1 : TrainNumOfSamples );
    trainDataStates = dataStates(: , 1 : TrainNumOfSamples );
    testData = data(  :, TrainNumOfSamples+1:end );
    testDataStates = dataStates(  :, TrainNumOfSamples+1:end );
    %%%%%
    statesInd = 1;
    for numOfSamples = 1 : length( NumOfSamplesVec )
        fprintf('run: %d/%d, samples %d / %d\n', run, NumOfRuns, NumOfSamplesVec( numOfSamples ) , TrainNumOfSamples);
        for numCompInd = 1 : length( NumCompVec )
            [dataTrun, hmmGTrun] = truncateDataModel( trainData, hmmG, NumOfSamplesVec( numOfSamples ), TrainNumOfSamples, NumCompVec( numCompInd ), NumCompG, NumOfViews );
            [CHmms, times] =  ExpOneRun(  dataTrun, NumOfStatesG, NumCompG, hmmGTrun, Algs, fileToSaveData);
            updateStatistics(CHmms, run, statesInd, numCompInd, numOfSamples, testData, testDataStates, times );
        end
        %save( wsFileName );
    end
    processStatistics( Err, Loglik,Time, NumOfStatesVec, NumCompVec, NumOfSamplesVec, NumOfAlgs, AlgsNames, Algs, run )
end
end

function [ dataTrun, HmmGTrun ] = truncateDataModel( data, hmmG, newNumOfSamples, NumOfSamplesG, newObsLength, ObsLengthG, NumOfViews)
dataTrun = data(:, 1: newNumOfSamples );
HmmGTrun = hmmG;
end

function updateStatistics(CHmms, run, statesInd, observInd, numOfSamplesInd, dataTest, dataTestStates, time )
global Err;
global Loglik;
global Time;
global RHmms;
global HmmGs;
for i = 1 : length( CHmms )
    if isempty( CHmms{i} )
        CErrA{i} = Inf;
        CErrB{i} = Inf;
        CLoglik{i} = -Inf;
        CTime{i} = Inf;
    else
        if ~isempty ( CHmms{i}.A )
            if i == 1 && numOfSamplesInd > 1
                CErrA{i} = cell2mat( Err{run,statesInd,observInd, numOfSamplesInd - 1}{1}( 1 ) ); % saving time of calculating error for hmmG
            else
            end
            CErrA{i} = norm( CHmms{i}.A - CHmms{1}.A , 'fro' );
        else
            CErrA{i} = Inf;
        end
        CErrB{i} = Inf;% norm( CHmms{i}.B - CHmms{1}.B , 'fro' );
        
        CLoglik{i} = -Inf;% CHmms{i}.calculateLoglik( dataTest );
        
        CTime{i} = time(i);
    end
end
CErr = {CErrA, CErrB};
Err{run,statesInd,observInd, numOfSamplesInd} = CErr;
Loglik{run,statesInd,observInd, numOfSamplesInd} = CLoglik;
Time{run,statesInd,observInd, numOfSamplesInd} = CTime;
RHmms{run,statesInd, observInd, numOfSamplesInd} = CHmms;
HmmGs{run} = CHmms{1};
end

function [dataStates, data] = generateSyntheticData(hmm, NumOfSamples)
[dataStates,data] = hmm.generateSamples(NumOfSamples);
end
