function estimateGHMM_demo()
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This DEMO construct a (non-aliased) Gaussian HMM, stochasticaly generate %
% a sequence of outputs from it and estimate a new Gaussian HMM from the   %
% generated data                                                           %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
addpath(genpath('.\HMMtoolbox'))
addpath(genpath('.\emgm'))
% define generating hmm's parameters %
numOfStates = 4;
A = [...
    0.1 0.1 0.0 0.5
    0.7 0.1 0.3 0.0;
    0.0 0.8 0.1 0.25;
    0.2 0.0 0.6 0.25];
mu    = [ -3, -1, 1, 3];
sigma = .5 * [ 1, 1, 1, 1 ];
% construct the generating hmm %
hmmG = AliasGHMM.NonAliasGHMM( numOfStates, A , mu, sigma);
% generate data from hmmG %
sequenceLength = 100000;
fprintf('generating data...\n');
[~,data] = hmmG.generateSamples( sequenceLength);
% estimate a GHMM from data %
ghmm = estimateGHMM( data, numOfStates);
% match ghmm to hmmG --- this step is for comparision only %
% ghmm = matchHmmToHmm( ghmm, hmmG); % finds a permutation of the states that make ghmm "as close as possible" to hmmG
% print estimated parameters %
fprintf('Estimated A =\n');
disp(ghmm.A);
fprintf('Estimated mu =\n');
disp(ghmm.mu)
fprintf('Estimated sigma =\n');
disp(ghmm.sigma)
end