function A = estimateTransitionMatrixGHMM(data, mu, sigma, compWeights)
% Estimate from data a transition matrix A using a quadradic program, given (estimation of) the output distribution parameters
% Output distributions are normal with means mu and variances sigma
%
% data -- 1 x T, where T length of sequence
% mu -- 1 x n vector of means, where n number of states
% sigma -- 1 x n vector of variances
% compWeights -- 1 x n vector of weights in the output mixture. 
%
% Return A -- n x n estimated transition matrix 
n = size(mu); % number of states
A = []; % transition matrix set to empty
hmmKnown = AliasGHMM.NonAliasGHMMe(n, A , mu, sigma, compWeights); % construct a Gaussian HMM with currently known parameters 
hmmNew = hmmKnown.learnNonAliasA( data ); % estimate the transition matrix A
A = hmmNew.A;
end