function [pdf_R] = pdf_Roy_H_Central(x,n_H,m,lambda) 
%function [pdf_R] = pdf_Roy_H_Central(x,n_H,m,lambda) 


num_std = 8; % number of standard deviations for numerical integration
tmin = n_H - num_std*sqrt(2*n_H); tmin=max(tmin,0); 
tmax = n_H + num_std*sqrt(2*n_H); 

n_points = 4097;

t_arr = linspace(tmin,tmax,n_points);
dt    = t_arr(2) - t_arr(1);


f = chi2pdf(t_arr,n_H); 

nx = length(x);

pdf_R = zeros(nx,1); 

for k=1:nx
    xm = (x(k)-(lambda+1)*t_arr) ./ ( 1+(n_H-1)./((lambda+1).*t_arr)); 
    xm = max(xm,0); 
    g  = f.*chi2pdf(xm,m-1) ./ ( 1+(n_H-1)./((lambda+1).*t_arr)); 
    pdf_R(k) = (sum(g) -1/2*(g(1)+g(end)) ) * dt; 
end
