function [pdf_R] = pdf_Roy_H_NonCentral(x,n_H,m,delta) 
%function [pdf_R] = pdf_Roy_H_NonCentral(x,n_H,m,delta) 
%
% delta is the non-centrality parameter

num_std = 8; % number of standard deviations for numerical integration
tmin = (n_H+delta) - num_std*sqrt(2*(n_H+2*delta)); tmin=max(tmin,1e-20); 
tmax = (n_H+delta) + num_std*sqrt(2*(n_H+2*delta)); 

n_points = 4097;

t_arr = linspace(tmin,tmax,n_points);
dt    = t_arr(2) - t_arr(1);


% the pdf of a non-central chi^2 with n_H d.f. and non-centrality delta. 
f = ncx2pdf(t_arr,n_H,delta); 

nx = length(x);

pdf_R = zeros(nx,1); 

for k=1:nx
    xm = (x(k)-t_arr) ./ ( 1+(n_H-1)./t_arr); 
    xm = max(xm,0); 
    g  = f.*chi2pdf(xm,m-1) ./ ( 1+(n_H-1)./t_arr); 
    pdf_R(k) = (sum(g) -1/2*(g(1)+g(end)) ) * dt; 
end
