delta_arr = [0 10 20 40]; 

%m = 3; p = 3; ni = 10; 
%m = 6; p = 3; ni = 10; 
%m = 6; p = 6; ni = 10;  
m = 10; p=6; ni = 20; 

n_delta = length(delta_arr); 

iter = 500000; 
for counter=1:iter
   
    if mod(counter,1000)==0
        fprintf('counter %d/%d\n',counter,iter); 
    end
    
    for k=1:n_delta; 
        delta = delta_arr(k); 
        
        [H E] = generate_data_MANOVA(m,p,ni,delta); 
        
        Einv = inv(E); 
        L = eig(Einv*H); 
        
        L1(k,counter) = max(L); 
    end
end

%% 
alpha = 0.01; 
L1_0_sorted = sort(L1(1,:),'descend'); 
threshold1 = L1_0_sorted(round(iter*alpha)); 

alpha = 0.05; 
threshold5 = L1_0_sorted(round(iter*alpha)); 

for k=1:n_delta
    power_R1(k) = sum(L1(k,:)>threshold1) / iter; 
    power_R5(k) = sum(L1(k,:)>threshold5) / iter; 
end

for k=2:n_delta
    power_Th1(k) = 1-cdf_Roys_Test_MANOVA(threshold1,p,ni*p,m,delta_arr(k));
    power_Th5(k) = 1-cdf_Roys_Test_MANOVA(threshold5,p,ni*p,m,delta_arr(k));
end

file_name = strcat('table3_m',num2str(m),'_p',num2str(p),'.mat'); 
save(file_name); 


%%

for k=2:n_delta
    fprintf('%4.0f & %4.0f & %4.0f & %4.0f & %4.3f &  %4.3f &  %4.3f &  %4.3f \\\n',m,p,ni,delta_arr(k),power_R1(k),power_Th1(k),power_R5(k),power_Th5(k)); 
end



