\name{gbins.summary}
\alias{gbins.summary}
\title{
Calculates summary statistics of a track expression for bins
}
\description{
Calculates summary statistics of a track expression for bins.
}
\usage{
gbins.summary([bin_expr, breaks]+, expr, intervals = ALLGENOME,
              include.lowest = FALSE, iterator = NULL,
              band = NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{bin_expr}{a track expression that determines the bin}
  \item{breaks}{breaks that define the bins}
  \item{expr}{track expression for which summary statistics is calculated}
  \item{intervals}{genomic scope for which the function is applied}
  \item{include.lowest}{if 'TRUE', the lowest value of the range determined by breaks is included}
  \item{iterator}{track expression iterator. If 'NULL' iterator is determined implicitly based on track expressions.}
  \item{band}{track expression band. If 'NULL' no band is used.}
}
\details{
This function is a binned version of 'gsummary'. For each iterator interval the value of 'bin_expr' is calculated and assigned to the corresponding bin determined by 'breaks'. The summary statistics of 'expr' are calculated then separatedly for each bin.

The bins can be multi-dimensional depending on the number of 'bin_expr'-'breaks' pairs.

The range of bins is determined by 'breaks' argument. For example: 'breaks=c(x1, x2, x3, x4)' represents three different intervals (bins): (x1, x2], (x2, x3], (x3, x4].

If 'include.lowest' is 'TRUE' the the lowest value will be included in the first interval, i.e. in [x1, x2].
}
\value{
Multi-dimensional array representing summary statistics for each bin.
}

\seealso{
\code{\link{gsummary}}, \code{\link{gintervals.summary}}, \code{\link{gdist}}
}
\examples{
gdb.init_examples()
gbins.summary("dense_track", c(0, 0.2, 0.4, 2), "sparse_track",
              intervals = gintervals(1), iterator = "dense_track")
}
\keyword{ ~summary }
