\name{gcluster.run}
\alias{gcluster.run}
\title{
Runs R commands on a cluster
}
\description{
Runs R commands on a cluster that supports SGE.
}
\usage{
gcluster.run(..., opt.flags = "", max.jobs = 400, debug = FALSE,
             R = "R")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{...}{R commands}
  \item{opt.flags}{optional flags for qsub command}
  \item{max.jobs}{maximal number of simultaneously submitted jobs}
  \item{debug}{if 'TRUE', additional reports are printed}
  \item{R}{command that launches R}
}
\details{
This function runs R commands on a cluster by distributing them among cluster nodes. It must run on a machine that supports Sun Grid Engine (SGE). The order in which the commands are executed can not be guaranteed, therefore the commands must be inter-independent.

Optional flags to 'qsub' command can be passed through 'opt.flags' parameter. Users are strongly recommended to use only '-l' flag as other flags might interfere with those that are already used (-terse, -S, -o, -e, -V). For additional information please refer to the manual of 'qsub'.

The maximal number of simultaneously submitted jobs is controlled by 'max.jobs'.

Set 'debug' argument to 'TRUE to allow additional report prints.

'gcluster.run' launches R on the cluster nodes to execute the commands. 'R' argument specifies how R executable should be invoked.
}
\value{
Return value ('retv') is a list, such that 'retv[[i]]' represents the result of the run of command number 'i'. Each result consists of 4 fields that can be accessed by 'retv[[i]]$FIELDNAME':

\tabular{ll}{
    \emph{FIELDNAME}   \tab \emph{DESCRIPTION}\cr
    exit.status \tab Exit status of the command. Possible values: 'success', 'failure' or 'interrupted'.\cr
    retv \tab Return value of the command.\cr
    stdout \tab Standard output of the command.\cr
    stderr \tab Standard error of the command.
}
}

\examples{
gdb.init_examples()
v <- 17
gcluster.run(
  gsummary("dense_track + v"),
  {
    intervs <- gscreen("dense_track > 0.1", gintervals(1, 2))
    gsummary("sparse_track", intervs)
  },
  gsummary("rects_track")
)
}
\keyword{ ~cluster }
