\name{gintervals}
\alias{gintervals}
\title{
Creates a set of 1D intervals
}
\description{
Creates a set of 1D intervals.
}
\usage{
gintervals(chroms, starts = 0, ends = -1, strands = NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{chroms}{chromosomes - an array of strings with or without "chr" prefixes or an array of integers (like: '1' for "chr1")}
  \item{starts}{an array of start coordinates}
  \item{ends}{an array of end coordinates. If '-1' chromosome size is assumed.}
  \item{strands}{'NULL' or an array consisting of '-1', '0' or '1' values}
}
\details{
This function returns a set of one-dimensional intervals. The returned value can be used in all functions that accept 'intervals' argument.

One-dimensional intervals is a data frame whose first three columns are 'chrom', 'start' and 'end'. Each row of the data frame represents a genomic interval of the specified chromosome in the range of [start, end). Additional columns can be presented in 1D intervals object yet these columns must be added after the three obligatory ones.

If 'strands' argument is not 'NULL' an additional column "strand" is added to the intervals. The possible values of a strand can be '1' (plus strand), '-1' (minus strand) or '0' (unknown).
}
\value{
A data frame representing the intervals.
}

\seealso{
\code{\link{gintervals.2d}}, \code{\link{gintervals.force_range}}
}
\examples{
gdb.init_examples()

## the following 3 calls produce identical results
gintervals(1)
gintervals("1")
gintervals("chrX")

gintervals(1, 1000)
gintervals(c("chr2", "chrX"), 10, c(3000, 5000))
}
\keyword{ ~intervals }
