\name{giterator.intervals}
\alias{giterator.intervals}
\title{
Returns iterator intervals
}
\description{
Returns iterator intervals given track expression, scope, iterator and band.
}
\usage{
giterator.intervals(expr = NULL, intervals = ALLGENOME,
                    iterator = NULL, band = NULL,
                    intervals.set.out = NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{expr}{track expression}
  \item{intervals}{genomic scope}
  \item{iterator}{track expression iterator. If 'NULL' iterator is determined implicitly based on track expression.}
  \item{band}{track expression band. If 'NULL' no band is used.}
  \item{intervals.set.out}{intervals set name where the function result is optionally outputed}
}
\details{
This function returns a set of intervals used by the iterator intervals for the given track expression, genomic scope, iterator and band. Some functions accept an iterator without accepting a track expression (like 'gtrack.create_pwm_energy'). These functions generate the values for each iterator interval by themselves. Use set 'expr' to 'NULL' to simulate the work of these functions.

If 'intervals.set.out' is not 'NULL' the result is saved as an intervals set. Use this parameter if the result size exceeds the limits of the physical memory.
}
\value{
If 'intervals.set.out' is 'NULL' a data frame representing iterator intervals.
}

\seealso{
\code{\link{giterator.cartesian_grid}}
}
\examples{
gdb.init_examples()

## iterator is set implicitly to bin size of 'dense' track
giterator.intervals("dense_track", gintervals(1, 0, 200))

## iterator = 30
giterator.intervals("dense_track", gintervals(1, 0, 200), 30)

## iterator is an intervals set named 'annotations'
giterator.intervals("dense_track", ALLGENOME, "annotations")

## iterator is set implicitly to intervals of 'array_track' track
giterator.intervals("array_track", gintervals(1, 0, 200))

## iterator is a rectangle 100000 by 50000
giterator.intervals("rects_track",
                    gintervals.2d(chroms1 = 1, chroms2 = "chrX"),
                    c(100000, 50000))
}
\keyword{ ~iterator }
\keyword{ ~intervals }
