\name{gtrack.array.import}
\alias{gtrack.array.import}
\title{
Creates an array track from array tracks or files
}
\description{
Creates an array track from array tracks or files.
}
\usage{
gtrack.array.import(track, description, [src]+)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{track}{name of the newly created track}
  \item{description}{a character string description}
  \item{src}{array track or name of a tab-delimited file}
}
\details{
This function creates a new 'Array' track from one or more "sources". Each source can be either another 'Array' track or a tab-delimited file that contains one-dimentional intervals and column values that should be added to the newly created track. One can learn about the exact format of the file by running 'gtrack.array.extract' or 'gextract' functions with a 'file' parameter and inspecting the output file.

There might be more than one source used to create the new track. In that case the new track will contain the columns from all the sources. The equally named columns are merged. Intervals that appear in one source but not in the other are added and the values for the missing columns are set to NaN. Intervals with all NaN values are not added. Partial overlaps between two intervals from different sources are forbidden.

 'description' is added as a track attribute.
}
\value{
None.
}

\seealso{
\code{\link{gextract}}, \code{\link{gtrack.array.extract}}, \code{\link{gtrack.array.set_colnames}}, \code{\link{gtrack.rm}}, \code{\link{gtrack.info}}, \code{\link{gdir.create}}
}
\examples{
f1 <- tempfile()
gextract("sparse_track", gintervals(1, 5000, 20000), file = f1)
f2 <- tempfile()
gtrack.array.extract("array_track", c("col2", "col3", "col4"),
                     gintervals(1, 0, 20000), file = f2)
f3 <- tempfile()
gtrack.array.extract("array_track", c("col1", "col3"),
                     gintervals(1, 0, 20000), file = f3)

gtrack.array.import("test_track1", "Test array track 1", f1, f2)
gtrack.array.extract("test_track1", NULL, ALLGENOME)

gtrack.array.import("test_track2", "Test array track 2",
                    "test_track1", f3)
gtrack.array.extract("test_track2", NULL, ALLGENOME)

gtrack.rm("test_track1", TRUE)
gtrack.rm("test_track2", TRUE)
unlink(c(f1, f2, f3))
}
\keyword{ ~array }
\keyword{ ~import }
\keyword{ ~create }
\keyword{ ~track }
