\name{gtrack.attr.export}
\alias{gtrack.attr.export}
\title{
Returns track attributes values
}
\description{
Returns track attributes values.
}
\usage{
gtrack.attr.export(tracks = NULL, attrs = NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{tracks}{a vector of track names or 'NULL'}
  \item{attrs}{a vector of attribute names or 'NULL'}
}
\details{
This function returns a data frame that contains track attributes values. Column names of the data frame consist of the attribute names, row names contain the track names.

The list of required tracks is specified by 'tracks' argument. If 'tracks' is 'NULL' the attribute values of all existing tracks are returned. 

Likewise the list of required attributes is controled by 'attrs' argument. If 'attrs' is 'NULL' all attribute values of the specified tracks are returned. The columns are also sorted then by "popularity" of an attribute, i.e. the number of tracks containing this attribute. This sorting is not applied if 'attrs' is not 'NULL'.

Empty character string in a table cell marks a non-existing attribute.
}
\value{
A data frame containing track attributes values.
}

\seealso{
\code{\link{gtrack.attr.import}}, \code{\link{gtrack.attr.get}}, \code{\link{gtrack.attr.set}}
}
\examples{
gdb.init_examples()
gtrack.attr.export()
gtrack.attr.export(tracks = c("sparse_track", "dense_track"))
gtrack.attr.export(attrs = "created.by")
}
\keyword{ ~attr }
\keyword{ ~attribute }

