\name{gtrack.create_pwm_energy}
\alias{gtrack.create_pwm_energy}
\title{
Creates a new track from PSSM energy function
}
\description{
Creates a new track from PSSM energy function.
}
\usage{
gtrack.create_pwm_energy(track, description, pssmset, pssmid,
                         prior, iterator)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{track}{track name}
  \item{description}{a character string description}
  \item{pssmset}{name of PSSM set: 'pssmset.key' and 'pssmset.data' must be presented in 'GROOT/pssms' directory}
  \item{pssmid}{PSSM id}
  \item{prior}{prior}
  \item{iterator}{track expression iterator for the newly created track}
}
\details{
This function creates a new track with values of a PSSM energy function. PSSM parameters (nucleotide probability per position and ploarization) are determined by 'pssmset' key and data files ('pssmset.key' and 'pssmset.data'). These two files must be located in 'GROOT/pssms' directory. The type of the created track is determined by the type of the iterator. 'description' is added as a track attribute.
}
\value{
None.
}

\seealso{
\code{\link{gtrack.create}}, \code{\link{gtrack.2d.create}}, \code{\link{gtrack.create_sparse}}, \code{\link{gtrack.smooth}}, \code{\link{gtrack.modify}}, \code{\link{gtrack.rm}}, \code{\link{gtrack.info}}, \code{\link{gdir.create}}
}
\examples{
gdb.init_examples()
gtrack.create_pwm_energy("pwm_energy_track", "Test track","pssm",
                         3, 0.01, iterator = 100)
gextract("pwm_energy_track", gintervals(1, 0, 1000))
gtrack.rm("pwm_energy_track", force = TRUE)
}
\keyword{ ~energy }
\keyword{ ~pssm }
\keyword{ ~pwm }
\keyword{ ~track }
