\name{gvtrack.create}
\alias{gvtrack.create}
\title{
Creates a new virtual track
}
\description{
Creates a new virtual track.
}
\usage{
gvtrack.create(vtrack, src, func = NULL, params = NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{vtrack}{virtual track name}
  \item{src}{source (track or intervals)}
  \item{func, params}{see below}
}
\details{
This function creates a new virtual track named 'vtrack' with the given source, function and parameters. 'src' can be either a track or intervals (1D or 2D). Use the following table for a reference of all valid source, function and parameters combinations:

\emph{src = [Track], func = "avg", params = NULL} \cr
Average track value in iterator interval.

\emph{src = [Track], func = "max", params = NULL} \cr
Maximal track value in iterator interval.

\emph{src = [Track], func = "min", params = NULL} \cr
Minimal track value in iterator interval.

\emph{src = ['Dense' / 'Sparse' / 'Array' track], func = "nearest", params = NULL} \cr
Mean track value in iterator interval. If there are no track values covered by an iterator interator (can occur only in 'Sparse' track), the nearest track value is returned.

\emph{src = ['Dense' / 'Sparse' / 'Array' track], func = "stdev", params = NULL} \cr
Unbiased standard deviation of track values in iterator interval.

\emph{src = ['Dense' / 'Sparse' / 'Array' track], func = "sum", params = NULL} \cr
Sum of track values in iterator interval.

\emph{src = ['Dense' / 'Sparse' / 'Array' track], func = "quantile", params = [Percentile in the range of [0, 1]]} \cr
Quantile of track values in iterator interval.

\emph{src = ['Dense' track], func = "global.percentile", params = NULL} \cr
Percentile of an average track value in iterator interval relatively to all values of the track.

\emph{src = ['Dense' track], func = "global.percentile.max", params = NULL} \cr
Percentile of a maximal track value in iterator interval relatively to all values of the track.

\emph{src = ['Dense' track], func = "global.percentile.min", params = NULL} \cr
Percentile of a minimal track value in iterator interval relatively to all values of the track.

\emph{src = [2D track], func = "area", params = NULL} \cr
Area covered by iterator interval.

\emph{src = [2D track], func = "weighted.sum", params = NULL} \cr
Weighted sum of values where each weight equals to the intersection area between the iterator interval and the rectangle containing the value.

\emph{src = [1D intervals], func = "distance", params = [Minimal distance from center (default: 0)]} \cr
Given the center 'C' of the current iterator interval returns 'DC * X/2', where 'DC' is the normalized distance to the center of the interval that contains 'C', and 'X' is the value of the parameter. If no interval contains 'C' the resulted value is 'D + XXX/2' where 'D' is the distance between 'C' and the edge of the closest interval. Distance can be positive or negative depending on the position of the coordinate relative to the interval and the strand (-1 or 1) of the interval. Distance is always positive if 'strand' is '0' or if 'strand' column is missing. Distance is 'NA' if no intervals exist for the current chromosome.

\emph{src = [1D intervals], func = "distance.center", params = NULL} \cr
Given the center 'C' of the current iterator interval returns 'NaN' if 'C' is outside of the intervals, otherwise returns the distance between 'C' and the center of the closest interval. Distance can be positive or negative depending on the position of the coordinate relative to the interval and the strand (-1 or 1) of the interval. Distance is always positive if 'strand' is '0' or if 'strand' column is missing.

Once a virtual track is created one can modify its iterator behavior by calling 'gvtrack.iterator' or 'gvtrack.iterator.2d'.
}
\value{
None.
}

\seealso{
\code{\link{gvtrack.info}}, \code{\link{gvtrack.iterator}}, \code{\link{gvtrack.iterator.2d}},  \code{\link{gvtrack.array.slice}}, \code{\link{gvtrack.ls}}, \code{\link{gvtrack.rm}}
}
\examples{
gdb.init_examples()

gvtrack.create("vtrack1", "dense_track", "max")
gvtrack.create("vtrack2", "dense_track", "quantile", 0.5)
gextract("dense_track", "vtrack1", "vtrack2",
         gintervals(1, 0, 10000), iterator = 1000)

gvtrack.create("vtrack3", "dense_track", "global.percentile")
gvtrack.create("vtrack4", "annotations", "distance")
gdist("vtrack3", seq(0, 1, l = 10), "vtrack4", seq(-500, 500, 200))
}
\keyword{ ~virtual }
