\name{gvtrack.iterator}
\alias{gvtrack.iterator}
\title{
Defines modification rules for a one-dimensional iterator in a virtual track
}
\description{
Defines modification rules for a one-dimensional iterator in a virtual track.
}
\usage{
gvtrack.iterator(vtrack, dim = NULL, sshift = 0, eshift = 0)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{vtrack}{virtual track name}
  \item{dim}{use 'NULL' or '0' for 1D iterators. '1' converts 2D iterator to (chrom1, start1, end1) , '2' converts 2D iterator to (chrom2, start2, end2)}
  \item{sshift}{shift of 'start' coordinate}
  \item{eshift}{shift of 'end' coordinate}
}
\details{
This function defines modification rules for one-dimensional iterator intervals in a virtual track. 

'dim' converts a 2D iterator interval (chrom1, start1, end1, chrom2, start2, end2) to a 1D interval. If 'dim' is '1' the interval is converted to (chrom1, start1, end1). If 'dim' is '2' the interval is converted to (chrom2, start2, end2). If 1D iterator is used 'dim' must be set to 'NULL' or '0' (meaning: no conversion is made).

Iterator interval's 'start' coordinate is modified by adding 'sshift'. Similarly 'end' coordinate is altered by adding 'eshift'.
}
\value{
None.
}

\seealso{
\code{\link{gvtrack.create}}, \code{\link{gvtrack.iterator.2d}}
}
\examples{
gdb.init_examples()

gvtrack.create("vtrack1", "dense_track")
gvtrack.iterator("vtrack1", sshift = 200, eshift = 200)
gextract("dense_track", "vtrack1", gintervals(1, 0, 500))

gvtrack.create("vtrack2", "dense_track")
gvtrack.iterator("vtrack2", dim = 1)
gextract("vtrack2", gintervals.2d(1, 0, 1000, 1, 0, -1),
         iterator = "rects_track")
}
\keyword{ ~virtual }
