#ifndef _GINTERVALSBIGSET_H_INCLUDED_
#define _GINTERVALSBIGSET_H_INCLUDED_

#include "rdbinterval.h"
#include "GInterval.h"

using namespace rdb;

//------------------------------------- GIntervalsBigSet ----------------------------------------
// !!!!!!!!! IN CASE OF ERROR THIS CLASS THROWS TGLException  !!!!!!!!!!!!!!!!

class GIntervalsBigSet {
public:
	enum Meta { STATS_FIELD, ZEROLINE_FIELD, NUM_META_FIELDS };

	static const char *META_FIELD_NAMES[NUM_META_FIELDS];

	static SEXP get_meta(const char *intervset, const IntervUtils &iu);
	static bool isbig(const char *intervset, const IntervUtils &iu);
	static void save_meta(const char *intervset, SEXP stats, SEXP zeroline, const IntervUtils &iu);

protected:
	GIntervalsBigSet() : m_iu(NULL) {}
	GIntervalsBigSet(const GIntervalsBigSet &) {}
	GIntervalsBigSet &operator=(const GIntervalsBigSet &) {}

	IntervUtils *m_iu;
	string       m_intervset;

	void init(const char *intervset, const IntervUtils &iu);
};

#endif

