#ifndef _GINTERVALSBIGSET1D_H_INCLUDED_
#define _GINTERVALSBIGSET1D_H_INCLUDED_

#include "GInterval.h"
#include "GIntervalsBigSet.h"
#include "GIntervalsFetcher1D.h"
#include "rdbinterval.h"

//------------------------------------- GIntervalsBigSet1D --------------------------------------
// !!!!!!!!! IN CASE OF ERROR THIS CLASS THROWS TGLException  !!!!!!!!!!!!!!!!

class GIntervalsBigSet1D : public GIntervalsBigSet, public GIntervalsFetcher1D {
public:
	enum StatCols {
		CHROM_COL, CONTAINS_OVERLAPS_COL, SIZE_COL, UNIFIED_OVERLAP_SIZE_COL, UNIFIED_TOUCHING_SIZE_COL,
		RANGE_COL, UNIFIED_OVERLAP_RANGE_COL, NUM_STAT_COLS
	};

	static const char *STAT_COL_NAMES[NUM_STAT_COLS];

	struct ChromStat {
		bool    contains_overlaps;
		size_t  size;
		size_t  unified_overlap_size;
		size_t  unified_touching_size;
		int64_t range;
		int64_t unified_overlap_range;

		ChromStat() : contains_overlaps(false), size(0), unified_overlap_size(0), unified_touching_size(0), range(0), unified_overlap_range(0) {}
	};

	GIntervalsBigSet1D() : GIntervalsFetcher1D(BIGSET1D) {}
	GIntervalsBigSet1D(const char *intervset, SEXP meta, const IntervUtils &iu) : GIntervalsFetcher1D(BIGSET1D) { init(intervset, meta, iu); }
	virtual ~GIntervalsBigSet1D() {}

	void init(const char *intervset, SEXP meta, const IntervUtils &iu);

	int64_t get_num_intervals(int chromid) const { return (*m_user_chrom2size)[chromid]; }

	void load_chrom(int chromid);

	const GIntervals &get_chrom_intervals() { return m_intervals; }

	static bool is1d(SEXP meta) { return length(VECTOR_ELT(meta, 0)) == NUM_STAT_COLS; }

	static pair<int, ChromStat> get_chrom_stat(GIntervalsFetcher1D *intervals);

	static void begin_save(const char *intervset, const IntervUtils &iu, vector<ChromStat> &chromstats);

	// saves generic intervals with optional additional columns
	static void save_chrom(const char *intervset, GIntervalsFetcher1D *intervals, SEXP rintervals, const IntervUtils &iu, vector<ChromStat> &chromstats);

	// ends save for generic intervals with optional additional columns
	static void end_save(const char *intervset, SEXP zeroline, const IntervUtils &iu, const vector<ChromStat> &chromstats);

	// saves plain intervals
	static void save_chrom_plain_intervals(const char *intervset, GIntervals &intervals, const IntervUtils &iu, vector<ChromStat> &chromstats);

	// ends save for plain intervals
	static void end_save_plain_intervals(const char *intervset, const IntervUtils &iu, const vector<ChromStat> &chromstats);

	//-------------------------------- GIntervalsFetcher1D interface -----------------------------------

	virtual GIntervalsFetcher1D *create_masked_copy(const set<int> &chromids_mask) const;

	virtual void seal() {}

	virtual size_t size() const { return m_size; }

	virtual size_t size(int chromid) const { return (*m_user_chrom2size)[chromid]; }

	virtual int num_chroms() const;

	virtual int64_t range() const { return m_range; }    // complexity: O(1)
	virtual int64_t range(int chromid) const { return m_do_unify_overlaps ? m_chrom2unified_overlap_range[chromid] : m_chrom2range[chromid]; } // complexity: O(1)

	virtual void begin_iter();

	virtual void begin_chrom_iter(int chromid);

	virtual bool next();
	virtual bool next_in_chrom();

	virtual bool isend() const { return m_iinterval >= m_intervals.end(); }
	virtual bool isend_chrom() const { return m_iinterval >= m_intervals.end() || m_cur_chromid != m_iter_chrom; }

	virtual GIntervals::const_iterator get_chrom_begin() const { return m_intervals.begin(); }
	virtual GIntervals::const_iterator get_chrom_end() const { return m_intervals.end(); }

	virtual size_t iter_index() const { return m_iter_index; }

	virtual size_t iter_chrom_index() const { return m_iter_chrom_index; }

	virtual const GInterval &cur_interval() const { return *m_iinterval; }

	virtual void sort(Compare_t = compare_by_start_coord);

	virtual void unify_overlaps(bool unify_touching_intervals = true);

	virtual void verify_no_overlaps(const GenomeChromKey &chromkey, const char *error_prefix = "") const;

private:
	GIntervals                 m_intervals;
	vector<int64_t>            m_chrom2size;
	vector<int64_t>            m_orig_chrom2size;
	vector<int64_t>            m_chrom2unified_overlap_size;
	vector<int64_t>            m_chrom2unified_touching_size;
	vector<int64_t>            m_chrom2range;
	vector<int64_t>            m_chrom2unified_overlap_range;
	vector<int64_t>           *m_user_chrom2size;
	size_t                     m_size;
	int64_t                    m_range;
	bool                       m_contains_overlaps;
	GIntervals::const_iterator m_iinterval;
	int                        m_cur_chromid;
	int                        m_iter_chrom;
	size_t                     m_iter_index;
	size_t                     m_iter_chrom_index;
	Compare_t                  m_compare;
	bool                       m_do_sort;
	bool                       m_do_unify_overlaps;
	bool                       m_unify_touching_intervals;
};

//------------------------------------- IMPLEMENTATION ------------------------------------------

inline int GIntervalsBigSet1D::num_chroms() const
{
	int res = 0;
	for (vector<int64_t>::const_iterator ichrom2size = m_user_chrom2size->begin(); ichrom2size < m_user_chrom2size->end(); ++ichrom2size) {
		if (*ichrom2size) 
			++res;
	}
	return res;
}

inline bool GIntervalsBigSet1D::next()
{
	++m_iinterval;
	++m_iter_index;
	++m_iter_chrom_index;
	if (m_iinterval >= m_intervals.end()) {
		++m_cur_chromid;
		for (; m_cur_chromid < (int)m_chrom2size.size(); ++m_cur_chromid) {
			if (get_num_intervals(m_cur_chromid)) {
				load_chrom(m_cur_chromid);
				m_iinterval = m_intervals.begin();
				break;
			}
		}
	}
	return isend();
}

inline bool GIntervalsBigSet1D::next_in_chrom()
{
	if (isend_chrom()) 
		return false;

	++m_iinterval;
	++m_iter_index;
	++m_iter_chrom_index;
	return !isend_chrom();
}

#endif

