#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "System.h"

size_t get_unique_mem_usage(pid_t pid)
{
	char filename[100];

	sprintf(filename, "/proc/%ld/smaps", (long)pid);
	FILE *fp = fopen(filename, "r");
	size_t mem_usage = 0;

	if (fp) {
		char buf[1000];
		bool is_private_dirty = false;
		
		while (fscanf(fp, "%999s", buf) && !feof(fp)) {
			if (!strcmp(buf, "Private_Dirty:"))
				is_private_dirty = true;
			else if (is_private_dirty) {
				char *endptr;
				long num;
				
				is_private_dirty = false;
				num = strtol(buf, &endptr, 10);
				if (!*endptr)
					mem_usage += num;
			}
		}
		fclose(fp);
	}
	return mem_usage * 1024;
}

