#include "TrackExpressionBigSet1DIterator.h"

bool TrackExpressionBigSet1DIterator::begin(const char *intervset, SEXP meta, GIntervalsFetcher1D &scope)
{
	TrackExpression1DIterator::begin(scope);
	m_bigset.init(intervset, meta, m_iu);
	m_bigset.sort();
	m_bigset.unify_overlaps(false);
	m_scope->begin_iter();
	m_intervals = NULL;

	if (m_scope->isend())
		end();

	return next();
}

bool TrackExpressionBigSet1DIterator::next()
{
	if (isend())
		return false;

	while (!m_scope->isend()) {
		if (!m_intervals || m_intervals->empty()) {
			const GInterval &scope_interval = m_scope->cur_interval();
			m_bigset.load_chrom(scope_interval.chromid);
			m_intervals = (GIntervals *)&m_bigset.get_chrom_intervals();
			m_icur_interval = m_intervals->begin() - 1;

			if (m_intervals->empty()) {
				// No intervals in the big set => skip all the scope with the same chromid.
				// To skip a chrom we put the scope to chromid+1. Note however that chromid+1 might be out of the range of available chromosomes.
				// bigin_chrom is fine with that, it will set then the iterator to the end.
				m_scope->begin_chrom_iter(scope_interval.chromid + 1);
				continue;
			}

			m_last_interval.chromid = m_scope->cur_interval().chromid;
			m_icur_interval = m_intervals->begin() - 1;
		}

		if (TrackExpressionIntervals1DIterator::next())
			return true;

		m_isend = false;
		m_intervals = NULL;
	}

	end();
	return false;
}
