#include "TrackExpressionBigSet2DIterator.h"

bool TrackExpressionBigSet2DIterator::begin(const char *intervset, SEXP meta, GIntervalsFetcher2D &scope, const DiagonalBand &band, int max_data_size)
{
	TrackExpression2DIterator::begin(scope, band);

	m_chromkey = (GenomeChromKey *)&m_iu.get_chromkey();
	m_max_data_size = max_data_size;
	m_scope->begin_iter();
	m_scope_idx = 0;
	m_scope_chrom_idx = 0;
	m_start_scope_idx = 0;
	m_intervals = NULL;
	m_intersection.clear();
	m_intersected_objs_indices.clear();
	m_iintersection = m_intersection.end();

	if (m_scope->isend())
		end();
	else {
		m_bigset.init(intervset, meta, m_iu);
		m_bigset.verify_no_overlaps(m_iu.get_chromkey(), "Initializing iterator ");
	}

	return next();
}

bool TrackExpressionBigSet2DIterator::next()
{
	if (isend())
		return false;

	while (1) {
		if (!m_intervals || m_icur_interval == m_intervals->end()) {
			int chromid1 = m_scope->cur_interval().chromid1();
			int chromid2 = m_scope->cur_interval().chromid2();

			if (m_band.is_non_empty_area() && chromid1 != chromid2 || !m_bigset.get_num_intervals(chromid1, chromid2)) {
				// skip all the scope with the same chromids
				m_scope->get_next_chroms(&chromid1, &chromid2);
				m_scope->begin_chrom_iter(chromid1, chromid2);
				if (m_scope->isend())
					break;
				continue;
			}

			m_bigset.load_chrom(chromid1, chromid2);
			m_intervals = (GIntervals2D *)&m_bigset.get_chrom_intervals();
			m_icur_interval = m_intervals->begin() - 1;
		}

		if (TrackExpressionIntervals2DIterator::next())
			return true;

		if (m_scope->isend())
			break;

		m_isend = false;
	}

	end();
	return false;
}
