#include "TrackExpressionSparseIterator.h"

bool TrackExpressionSparseIterator::begin(const string &track_dir, GIntervalsFetcher1D &scope)
{
	TrackExpression1DIterator::begin(scope);

	m_track_dir = track_dir + "/";
	m_scope->begin_iter();
	m_intervals = NULL;

	if (m_scope->isend())
		end();

	return next();
}

bool TrackExpressionSparseIterator::next()
{
	if (isend())
		return false;

	while (!m_scope->isend()) {
		if (!m_intervals || m_intervals->empty()) {
			const GInterval &scope_interval = m_scope->cur_interval();
			string track_filename = m_track_dir + "/" + GenomeTrack::get_1d_filename(m_iu.get_chromkey(), scope_interval.chromid);

			if (m_track_type == GenomeTrack::ARRAYS) {
				m_track_arrays.init_read(track_filename.c_str(), scope_interval.chromid);
				m_intervals = (GIntervals *)&m_track_arrays.get_intervals();
			} else if (m_track_type == GenomeTrack::SPARSE) {
				m_track_sparse.init_read(track_filename.c_str(), scope_interval.chromid);
				m_intervals = (GIntervals *)&m_track_sparse.get_intervals();
			} else
				TGLError<TrackExpressionSparseIterator>("Unrecognized track type for sparse iterator");

			if (m_intervals->empty()) {
				// No intervals in the sparse file => skip all the scope with the same chromid.
				// To skip a chrom we put the scope to chromid+1. Note however that chromid+1 might be out of the range of available chromosomes.
				// bigin_chrom is fine with that, it will set then the iterator to the end.
				m_scope->begin_chrom_iter(scope_interval.chromid + 1);
				continue;
			}

			m_last_interval.chromid = m_scope->cur_interval().chromid;
			m_icur_interval = m_intervals->begin() - 1;
		}

		if (TrackExpressionIntervals1DIterator::next())
			return true;

		m_isend = false;
		m_intervals = NULL;
	}

	end();
	return false;
}
