#include <unistd.h>

#include "TrackExpressionTrackRectsIterator.h"
#include "rdbutils.h"

TrackExpressionTrackRectsIterator::TrackExpressionTrackRectsIterator(IntervUtils &iu) :
	m_iu(iu),
	m_track_rects(iu.get_track_chunk_size(), iu.get_track_num_chunks()),
	m_track_points(iu.get_track_chunk_size(), iu.get_track_num_chunks()),
	m_track_computed(rdb::get_groot(iu.get_env()), iu.get_track_chunk_size(), iu.get_track_num_chunks())
{}

bool TrackExpressionTrackRectsIterator::begin(const string &track_dir, GenomeTrack::Type track_type, GIntervalsFetcher2D &scope, const DiagonalBand &band, uint64_t max_data_size)
{
	m_track = NULL;
	m_track_dir = track_dir + "/";
	m_track_type = track_type;
	TrackExpressionIntervals2DIterator::init(m_iu.get_chromkey(), m_cur_intervals, scope, band, max_data_size);
	m_isend = false;

	if (m_scope->isend())
		end();

	return next();
}

bool TrackExpressionTrackRectsIterator::next()
{
	if (isend())
		return false;

	while (1) {
		if (!m_track || m_track->is_end_interval()) {
			if (m_scope->isend())
				break;

			int chromid1 = m_scope->cur_interval().chromid1();
			int chromid2 = m_scope->cur_interval().chromid2();

			string track_filename = m_track_dir + "/" + GenomeTrack::get_2d_filename(m_iu.get_chromkey(), chromid1, chromid2);

			if (m_band.is_non_empty_area() && chromid1 != chromid2 || access(track_filename.c_str(), R_OK) < 0 && errno == ENOENT)
				m_track = NULL;
			else {
				if (m_track_type == GenomeTrack::RECTS) {
					m_track_rects.init_read(track_filename.c_str(), chromid1, chromid2);
					m_track = &m_track_rects;
				} else if (m_track_type == GenomeTrack::POINTS) {
					m_track_points.init_read(track_filename.c_str(), chromid1, chromid2);
					m_track = &m_track_points;
				} else if (m_track_type == GenomeTrack::COMPUTED) {
					m_track_computed.init_read(track_filename.c_str(), chromid1, chromid2);
					m_track = &m_track_computed;
				} else
					verror("Invalid track type %d used in TrackExpressionTrackRectsIterator", (int)m_track_type);

				m_cur_intervals.clear();

				if (m_track->begin_interval())
					m_cur_intervals.push_back(m_track->cur_interval());
				else
					m_track = NULL;
			}

			if (!m_track) {
				// skip all the scope with the same chromids
				m_scope->get_next_chroms(&chromid1, &chromid2);
				m_scope->begin_chrom_iter(chromid1, chromid2);
				if (m_scope->isend())
					break;
				continue;
			}

			m_icur_interval = m_intervals->begin() - 1;
		}

		if (TrackExpressionIntervals2DIterator::next())
			return true;

		m_isend = false;

		if (m_track->next_interval()) {
			// add the next interval as the second element in the vector:
			// when the interval iterator is set before the first element, it triggers population of
			// scope QuadTree in TrackExpressionIntervals2DIterator::next()
            if (m_cur_intervals.size() == 1)
            	m_cur_intervals.push_back(m_track->cur_interval());
            else
            	m_cur_intervals.back() = m_track->cur_interval();
			m_icur_interval = m_intervals->begin();
		} else
			m_track = NULL;
	}

	end();
	return false;
}
