#ifndef TRACKEXPRESSIONTRACK2DRECTSITERATOR_H_
#define TRACKEXPRESSIONTRACK2DRECTSITERATOR_H_

#include "GenomeTrackComputed.h"
#include "GenomeTrackRects.h"
#include "rdbinterval.h"
#include "TrackExpressionIntervals2DIterator.h"

//------------------------------ TrackExpressionTrackRectsIterator ---------------------------------

using namespace rdb;

class TrackExpressionTrackRectsIterator : public TrackExpressionIntervals2DIterator {
public:
	TrackExpressionTrackRectsIterator(IntervUtils &iu);

	bool begin(const string &track_dir, GenomeTrack::Type track_type, GIntervalsFetcher2D &scope, const DiagonalBand &band, uint64_t max_data_size);
	virtual bool next();

protected:
	string                  m_track_dir;
	IntervUtils            &m_iu;
	GenomeTrack2D          *m_track;
	GenomeTrackRectsRects   m_track_rects;
	GenomeTrackRectsPoints  m_track_points;
	GenomeTrackComputed     m_track_computed;
	GenomeTrack::Type       m_track_type;
	GIntervals2D            m_cur_intervals;
};

#endif /* TRACKEXPRESSIONTRACK2DRECTSITERATOR_H_ */
